package gov.va.med.edp.vo.reports
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	/**
	 * Holds the report log entries. 
	 */
	public class ReportLogEntryVO implements IValueObject
	{
		/**
		 * The id of the log entry. 
		 */
		public var id: int;
		/**
		 * The patient name entry. 
		 */
		public var patientNm:String;
		/**
		 * The acuity entry. 
		 */
		public var acuity: int;
		/**
		 * The adm dec entry. 
		 */
		public var admDec: int;
		/**
		 * The adm del entry. 
		 */
		public var admDel: int;
		/**
		 * The complaint entry. 
		 */
		public var complaint: String;
		/**
		 * The disposition entry. 
		 */
		public var disposition: String;
		/**
		 * The diagnoses entry. 
		 */
		public var diagnoses: ArrayCollection = new ArrayCollection();
		/**
		 * The elapsed time entry. 
		 */
		public var elapsed: String;
		/**
		 * The time in entry. 
		 */
		public var timeIn: Date;
		/**
		 * The time out entry. 
		 */
		public var timeOut: Date;
		/**
		 * The provider entry. 
		 */
		public var provider: String;
		/**
		 * The triage entry. 
		 */
		public var triage: int;
		/**
		 * The wait entry. 
		 */
		public var wait: int;
		/**
		 * The arrival entry. 
		 */
		public var arrival: String;
		/**
		 * The ICD9 entry. 
		 */
		public var icd9: String;
		/**
		 * The delay reason entry. 
		 */
		public var delayReason: String;
		/**
		 * The observation entry. 
		 */
		public var observation: String;
		
		/**
		 *   Constructor.
		 */
		public function ReportLogEntryVO() 
		{
		}
		
	}
}