package gov.va.med.edp.vo.reports
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	/**
	 * Class that holds the patient demographic data
	 */
	[Bindable]
	public class PtDemographicsVO implements IValueObject
	{
		/**
		 * The address field. 
		 */
		public var address1: String;
		/**
		 * The address field. 
		 */
		public var address2: String;
		/**
		 * The address field. 
		 */
		public var address3: String;
		/**
		 * The date died. 
		 */
		public var died: Date;
		/**
		 * The age field. 
		 */
		public var age: String;
		/**
		 * The city field. 
		 */
		public var city: String;
		/**
		 * The date of birth. 
		 */
		public var dob: String;
		/**
		 * The service connected indicator. 
		 */
		public var isServiceConnected: String;
		/**
		 * The veteran indicator. 
		 */
		public var isVeteran: String;
		/**
		 * The marital status. 
		 */
		public var maritalSts: String;
		/**
		 * The service connected percent. 
		 */
		public var serviceConnectedPct: String;
		/**
		 * The sex. 
		 */
		public var sex: String;
		/**
		 * The social security number. 
		 */
		public var ssn: String;
		/**
		 * The state. 
		 */
		public var state: String;
		/**
		 * The zip code. 
		 */
		public var zip: String;
		/**
		 * The name. 
		 */
		public var name: String;
		/**
		 * The phone field. 
		 */
		public var phone: String;
		/**
		 * The cell phone number. 
		 */
		public var cell: String;
		/**
		 * The phone field. 
		 */
		public var nokPhone: String;
		/**
		 * The nok field. 
		 */
		public var nok: String;
		/**
		 * The changed indicator. 
		 */
		public var changed: Boolean = false;
		
		/**
		 *   Constructor.
		 */
		public function PtDemographicsVO() 
		{
		}
		
		/**
		 * Returns the string representation of demographic information.
		 *  
		 * @return  String  the string of demographic elements
		 * 
		 */
		public function toString():String
		{
			var x: String =
				"address1=" + address1 + "\t" +
				"address2=" + address2 + "\t" +
				"address3=" + address3 + "\t" +
				"city=" + city + "\t" +
				"state=" + state + "\t" +
				"zip=" + zip + "\t" +
				"phone=" + phone + "\t";
			return x;
		}
		
	}
}