package gov.va.med.edp.vo.reports
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	/**
	 * Holds the patient removed in error report data.
	 * 
	 */
	public class PatientRemovedInErrorVO implements IValueObject
	{
		/** Patient Name. */
		public var patientName: String;
		/** Time in ED. */
		public var timeInED: Date;
		/** Time out of ED. */
		public var timeOutED: Date;
		/** Is this record restored. */
		public var restored: int;
		/** When the record was restred. */
		public var restoredDateTime: Date;
		/** Who restored the record. */
		public var restoredBy: String;	
		/** Closed time. */
		public var closedDateTime: Date;		
		/** Who closed the record. */
		public var closedBy: String;	
		/** Patient SSN. */
		public var ssn: String;
		
		/**
		 *   Constructor.
		 */
		public function PatientRemovedInErrorVO() 
		{
		}
		
		/**
		 * Returns the string representation of this report parameters.
		 *  
		 * @return String  the string of this report parameters
		 * 
		 */
		public function toString():String
		{
			var x: String = "patientName=" + patientName + "\t" +
				"timeInED=" + timeInED + "\t" +
				"timeOutED=" + timeOutED + "\t" +
				"restored=" + restored + "\t" +
				"restoredDateTime=" + restoredDateTime + "\t" +
				"restoredBy=" + restoredBy + "\t" +
				"closedBy=" + closedBy + "\t" +
				"ssn=" + ssn + "\t" +
				"closedDateTime=" + closedDateTime;
			return x;
		}	
	}
}