package gov.va.med.edp.vo.reports
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	/**
	 * Holds the custom report entries. 
	 */
	public class CustomReportVO implements IValueObject
	{
		/**
		 * The md entry.
		 */
		public var md: String;
		/**
		 * The status entry.
		 */
		public var status: String;
		/**
		 * The complaint entry.
		 */
		public var complaint: String;
		/**
		 * The adm delay entry.
		 */
		public var admDelay: String;
		/**
		 * The mds entry.
		 */
		public var mDs: String;
		/**
		 * The triage Rn entry.
		 */
		public var triageRn: String;
		/**
		 * The staff Rn entry.
		 */
		public var staffRns: String;
		/**
		 * The acuity entry.
		 */
		public var acuity: String;
		/**
		 * The wait time entry.
		 */
		public var wait: String;
		/**
		 * The door to doc entry.
		 */
		public var doorToDoc: String;
		/**
		 * The admin dec entry.
		 */
		public var adminDec: String;
		/**
		 * The rNs entry.
		 */
		public var rNs: String;
		/**
		 * The dcDx entry.
		 */
		public var dcDx: String;
		/**
		 * The diag code entry.
		 */
		public var diagCode: String;
		/**
		 * The source entry.
		 */
		public var source: String;
		/**
		 * The ptIdentifier entry.
		 */
		public var ptIdentifier: String;
		/**
		 * The resident entry.
		 */
		public var resident: String;
		/**
		 * The elapsed time entry.
		 */
		public var elapsedTime: String;
		/** Patient Name. */
		public var patientName: String;
		/** Time in ED. */
		public var timeInED: Date;
		/** Time out of ED. */
		public var timeOutED: Date;
		/** Is this record restored. */
		public var restored: int;
		/** When the record was restred. */
		public var restoredDateTime: Date;
		/** Who restored the record. */
		public var restoredBy: String;	
		/** Closed time. */
		public var closedDateTime: Date;		
		/** Who closed the record. */
		public var closedBy: String;	
		/** Patient SSN. */
		public var ssn: String;
		
		/**
		 *   Constructor.
		 */
		public function CustomReportVO() 
		{
		}
		
		/**
		 * Returns the string representation of custom report parameters.
		 *  
		 * @return  String  the string of custom report parameters
		 * 
		 */
		public function toString():String
		{
			var x: String = "md=" + md + "\t" +
				"status=" + status + "\t" +
				"complaint=" + complaint + "\t" +
				"admDelay=" + admDelay + "\t" +
				"mDs=" + mDs + "\t" +
				"triageRn=" + triageRn + "\t" +
				"staffRns=" + staffRns + "\t" +
				"acuity=" + acuity + "\t" +
				"wait=" + wait + "\t" +
				"doorToDoc=" + doorToDoc + "\t" +
				"adminDec=" + adminDec + "\t" +
				"rNs=" + rNs + "\t" +
				"dcDx=" + dcDx + "\t" +
				"diagCode=" + diagCode + "\t" +
				"source=" + source + "\t" +
				"ptIdentifier=" + ptIdentifier + "\t" +
				"resident=" + resident + "\t" +
				"elapsedTime=" + elapsedTime + "\t" +
				"patientName=" + patientName + "\t" +
				"timeInED=" + timeInED + "\t" +
				"timeOutED=" + timeOutED + "\t" +
				"restored=" + restored + "\t" +
				"restoredDateTime=" + restoredDateTime + "\t" +
				"restoredBy=" + restoredBy + "\t" +
				"closedBy=" + closedBy + "\t" +
				"ssn=" + ssn + "\t" +
				"closedDateTime=" + closedDateTime;
			return x;
		}	
	}
}