package gov.va.med.edp.vo {

	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.util.Vista;

	/**
	 * Stores Vitals for a given patient
	 */
	[Bindable]
	public class VitalsVO
	{
		/**
		 * The blood pressure entry. 
		 */
		public var bp: String;
		/**
		 * The height. 
		 */
		public var ht: String;
		/**
		 * The pulse. 
		 */
		public var p: String;
		/**
		 * The pain severity. 
		 */
		public var pn: String;
		/**
		 * The Resp. 
		 */
		public var r: String;
		/**
		 * The temperature in F. 
		 */
		public var t: String;
		/**
		 * The weight. 
		 */
		public var wt: String;
		/**
		 * The error indicator. 
		 */
		public var error: Boolean = false;
		/**
		 * The time value. 
		 */
		public var time: String;
		/**
		 * The time display value. 
		 */
		public var timeDisplayString: String;
		
		/**
		 *   Constructor.
		 */
		public function VitalsVO() 
		{
		}
		
		/**
		 * Returns the string representation of vitals.
		 *  
		 * @return  String  the string of vitals
		 * 
		 */
		public function toString():String
		{
			
			var now:Date = new Date();
			
			var x: String =
				"BP=" + bp + "^" +
				"HT=" + ht + "^" +
				"P=" + p + "^" +
				"PN=" + pn + "^" +
				"R=" + r + "^" +
				"T=" + t + "^" +
				"WT=" + wt + "^" +
				"ERROR=" + (error ? "true" : "false") + "^" +
				"TIME=" + Vista.DatetoFM_Seconds(now);
				return x;
		}

	}
}