/* StaffMemberVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the staff member details.
	 */
	public class StaffMemberVO implements IValueObject
	{
		/**
		 * The duz identifier.
		 */
		public var duz: String;
		/**
		 * The inactive indicator.
		 */
		public var inactive: Boolean = false;
		/**
		 * The name of staff member.
		 */
		public var name: String;
		/**
		 * The initials.
		 */
		public var initials: String;
		/**
		 * The role of staff member.
		 */
		public var role: String;
		/**
		 * The color selection object.
		 */
		public var color: ColorSelectionVO;
		/**
		 * The color changed indicator.
		 */
		public var colorChanged: Boolean = false;
		/**
		 * The changed indicator.
		 */
		public var changed: Boolean = false;
		/**
		 * The display name.
		 */
		public var displayName:String;

		/**
		 *   Constructor.
		 */
		public function StaffMemberVO() 
		{
		}
		/**
		 * Returns the string representation of staff member entries.
		 *  
		 * @return  String  the string of staff member entries
		 * 
		 */
		public function toString(): String
		{
			// in the string form, the first comma piece is 1 if Code should be used
			
			var isChanged: Boolean = (changed || colorChanged);
			var x: String =
				"duz=" + duz + "\t" +
				"inact=" + (inactive ? "1" : "0") + "\t" +
				"nm=" + name + "\t" +
				"itl=" + initials + "\t" +
				"role=" + role + "\t" +
				"clr=" + color.toString() + "\t" +
				"chg=" + (isChanged ? "1" : "0") + "\t";
			return x;
		}
	}
}