/* SessionVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the session information.
	 */
	public class SessionVO implements IValueObject
	{
		/**
		 * The duz identifier.
		 */
		public var duz: String;
		/**
		 * The user name.
		 */
		public var userName: String;
		/**
		 * The station number.
		 */
		public var site: String;	        // this is the Station Number!!
		/**
		 * The site name.
		 */
		public var siteName: String;
		/**
		 * The area identifier.
		 */
		public var area: int;
		/**
		 * The area name.
		 */
		public var areaName: String;
		/**
		 * The board name.
		 */
		public var board: String;
		/**
		 * The site time FM.
		 */
		public var siteTimeFM: String;
		/**
		 * The site time.
		 */
		public var siteTime: Date;
		/**
		 * The base time.
		 */
		public var baseTime: Date;
		/**
		 * The time out in  milli seconds.
		 */
		public var timeOut: int = 300000;   // milliseconds == 5 minutes
		/**
		 * The count down in milli seconds.
		 */
		public var countDown: int = 10000;  // milliseconds == 10 secs
		/**
		 * The show adhoc report indicator.
		 */
		public var showAdhocReport:Boolean = false;
		/**
		 * The can export indicator.
		 */
		public var canExport: Boolean = false;
		/**
		 * The show provider report indicator.
		 */
		public var showProviderReport: Boolean = false;
		/**
		 * The show patient cross reference report indicator.
		 */
		public var showPatientCrossReferenceReport: Boolean = false;
		/**
		 * The debug enabled indicator.
		 */
		public var debugEnabled: Boolean = false;
		/**
		 * The server package version.
		 */
        public var serverPackageVersion: String;
		
		//public var icd10ActivationDate: Date; //PFlores: (9/25/2012) added attribute
		/**
		 * The role identifier.
		 */
		public var roleID:String = "";
		/**
		 * The role name.
		 */
		public var roleName:String;	
		/**
		 * The default worksheet.
		 */
		public var defaultWorksheet:String;
		/**
		 * The default board.
		 */
		public var defaultBoard:String;
		/**
		 * The default room.
		 */
		public var defaultRoom:String;
		/**
		 * The role abbreviation.
		 */
		public var roleAbbr:String;
		/**
		 *   Constructor.
		 */
		public function SessionVO() 
		{
		}
		
		/**
		 * Returns the string representation of session parameters.
		 *  
		 * @return  String  the string of session parameters
		 * 
		 */
		public function toString():String
		{
			var x: String =
				"duz= " + duz + "\t" +
				"userName= " + userName + "\t" +
				"site= " + site + "\t" +
				"siteName= " + siteName + "\t" +
				"area= " + area + "\t" +
				"areaName= " + areaName + "\t" +
				"board= " + board + "\t" +
				"siteTimeFM= " + siteTimeFM + "\t" +
				"siteTime= " + siteTime + "\t" +
				"baseTime= " + baseTime + "\t" +
				"timeOut= " + timeOut + "\t" +
				"countDown= " + countDown + "\t" +
				"canExport= " + canExport + "\t" +
				"showProviderReport= " + showProviderReport + "\t" +
				"showPatientCrossReferenceReport= " + showPatientCrossReferenceReport + "\t" +
				"debugEnabled= " + debugEnabled + "\t" +
				"serverPackageVersion= " + serverPackageVersion + "\t" +
				"roleAbbr= " + roleAbbr + "\t" +
				"roleID= " + roleID + "\t" +
				"roleName= " + roleName + "\t" +
				"defaultWorksheet= " + defaultWorksheet + "\t" +
				"defaultRoom= " + defaultRoom + "\t" +
				"defaultBoard= " + defaultBoard;
			return x;
		}
		
    }
}
