/* RoomBedVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the room bed information. 
	 */
	public class RoomBedVO implements IValueObject
	{
		/**
		 * The id. 
		 */
		public var id: int;
		/**
		 * The area entry. 
		 */
		public var area: int;
		/**
		 * The name entry. 
		 */
		public var name: String = "";
		/**
		 * The inactive indicator. 
		 */
		public var inactive: Boolean;
		/**
		 * The primary value. 
		 */
		public var primary: String = "1";  //  all beds default to primary for now
		/**
		 * The sequence number. 
		 */
		public var sequence: int;
		/**
		 * The display name. 
		 */
		public var displayName: String = "";
		/**
		 * The display when value. 
		 */
		public var displayWhen: int;
		/**
		 * The default status value. 
		 */
		public var defaultStatus: int;
		/**
		 * The category value. 
		 */
		public var category: int;
		/**
		 * The shared name. 
		 */
		public var sharedName: String = "";
		/**
		 * The board name. 
		 */
		public var boardName: String = "";
		/**
		 * The color selection object. 
		 */
		public var color: ColorSelectionVO = new ColorSelectionVO();
		/**
		 * The changed indicator. 
		 */
		public var changed: Boolean = false;

		/**
		 *   Constructor.
		 */
		public function RoomBedVO() 
		{
		}
		/**
		 * Returns the string representation of room bed parameters.
		 *  
		 * @return  String  the string of room bed parameters
		 * 
		 */
		public function toString():String
		{
			var x: String =
				"id=" + id + "\t" +
				"area=" + area + "\t" +
				"name=" + name + "\t" +
				"inactive=" + (inactive ? "1" : "0") + "\t" +
				"primary=" + primary + "\t" +
				"seq=" + sequence + "\t" +
				"display=" + displayName + "\t" +
				"when=" + displayWhen + "\t" +
				"status=" + defaultStatus + "\t" +
				"category=" + category + "\t" +
				"shared=" + sharedName + "\t" +
				"board=" + boardName + "\t" +
				"color=" + color.toString() + "\t" +
				"changed=" + (changed ? "1" : "0");
			return x;
		}
		
	}
}