/* RadiologyOrderVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Value object that is a container for a radiology order.
	 * @author useruseruser12
	 * 
	 */
	public class RadiologyOrderVO implements IValueObject
	{
		/**
		 * Date of the exam.
		 */
		public var examDate: String = "";
		/**
		 * Physician required.
		 */
		public var reqPhys: String = "";
		/**
		 * Location of the order.
		 */
		public var pLoc: String = "";
		/**
		 * Image location of the order.
		 */
		public var iLoc: String = "";
		/**
		 * The entire report in text form.
		 */
		public var report: String = "";
		
		/**
		 *   Constructor.
		 */
		public function RadiologyOrderVO() 
		{
		}
		
		/**
		 * Get the String interpretation of this object.
		 * @return The string interpretation of this object.
		 * 
		 */
		public function toString(): String
		{
			/*var x: String =
				"examDate=" + examDate + "\t" +
				"reqPhys=" + reqPhys + "\t" +
				"pLoc=" + pLoc + "\t" +
				"iLoc=" + iLoc + "\t";
			*/
			var x: String =
				"Report=" + report + "\t";
			return x;
		}
	}
}