/* PCECodedValueVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the PCE coded value information. 
	 */
	public class PCECodedValueVO implements IValueObject
	{
		/**
		 * The type of the value. 
		 */
		public var type: String;
		/**
		 * The IEN. 
		 */
		public var ien: int;
		/**
		 * The actual code. 
		 */
		public var code: String;
		/**
		 * The label entry. 
		 */
		public var label: String;
		/**
		 * The added indicator. 
		 */
		public var added: Boolean = false;
		/**
		 * The updated indicator. 
		 */
		public var updated: Boolean = false;
		/**
		 * The remove indicator. 
		 */
		public var remove: Boolean = false;
		/**
		 * The primary indicator. 
		 */
		public var primary: Boolean;
		/**
		 * The quantity value. 
		 */
		public var quantity: int;
		
		/**
		 *   Constructor.
		 */
		public function PCECodedValueVO() 
		{
		}
	}
}