/* LogEntryVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import gov.va.med.edp.util.Vista;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	/**
	 * Holds the log entry values.
	 */
	public class LogEntryVO implements IValueObject
	{
		/**
		 * The id of log entry. 
		 */
		public var id: Number;
		/**
		 * The site log entry. 
		 */
		public var site: int;
		/**
		 * The area log entry. 
		 */
		public var area: int;
		/**
		 * The patient dfn. 
		 */
		public var dfn: String;
		/**
		 * The name log entry. 
		 */
		public var name: String;
		/**
		 * The ssn log entry. 
		 */
		public var ssn: String;
		/**
		 * The date of birth. 
		 */
		public var dob: String;
		/**
		 * The arrival time. 
		 */
		public var arrival: int;
		/**
		 * The inTS time entry. 
		 */
		public var inTS: Date = new Date();
		/**
		 * The visit entry. 
		 */
		public var visit: int;
		/**
		 * The clinic entry. 
		 */
		public var clinic: int;
		/**
		 * The closed indicator. 
		 */
		public var closed: Boolean;
		/**
		 * The complaint entry. 
		 */
		public var complaint: String;
		/**
		 * The long complaint entry. 
		 */
		public var longComplaint: String;
		/**
		 * The status entry. 
		 */
		public var status: int;
		/**
		 * The acuity level. 
		 */
		public var acuity: int;
		/**
		 * The bed entry. 
		 */
		public var bed: int;
		/**
		 * The provider entry. 
		 */
		public var provider: String;
		/**
		 * The resident entry. 
		 */
		public var resident: String;
		/**
		 * The nurse entry. 
		 */
		public var nurse: String;
		/**
		 * The comments entry. 
		 */
		public var comment: String;
		/**
		 * The outTS time entry. 
		 */
		public var outTS: Date = new Date();
		/**
		 * The delay entry. 
		 */
		public var delay: int;
		/**
		 * The observation log entry. 
		 */
		public var observation: int;
		/**
		 * The disposition log entry. 
		 */	
		public var disposition: int;
		/**
		 * The diagnoses log entry. 
		 */			
		public var diagnoses: ArrayCollection = new ArrayCollection();
		/**
		 * The required log entry. 
		 */			
		public var required: String;
		/**
		 * The is stub indicator. 
		 */			
		public var isStub: Boolean = false;
		/**
		 * The remove ready indicator. 
		 */			
		public var removeReady: Boolean = false;
		/**
		 * The restore ready indicator. 
		 */			
		public var restoreReady: Boolean = false;
		/**
		 * The require delay indicator. 
		 */			
		public var requireDelay: Boolean = false;
		/**
		 * The require disposition indicator. 
		 */			
		public var requireDisposition: Boolean = false;
		/**
		 * The require diagnosis indicator. 
		 */			
		public var requireDiagnosis: Boolean = false;
		/**
		 * The updated diagnoses indicator. 
		 */			
		public var updatedDiagnoses: Boolean = false;
		/**
		 * The patient flags indicator. 
		 */			
		public var patientFlags: ArrayCollection;
		/**
		 * The load ts indicator. 
		 */			
		public var loadTS: String;  // Fileman time for when record loaded, no need to made Date		
		
		
		/**
		 *   Constructor.
		 */
		public function LogEntryVO() 
		{
		}
		/**
		 * Returns the string representation of log entry values.
		 *  
		 * @return  String  the string of log entry values
		 * 
		 */
		public function toString():String
		{
			var x: String =
				"id=" + id + "\t" +
				"site=" + site + "\t" +
				"area=" + area + "\t" +
				"dfn=" + dfn + "\t" +
				"name=" + name + "\t" +
				"ssn=" + ssn + "\t" +
				"dob=" + dob + "\t" +
				"arrival=" + arrival + "\t" +
				"clinic=" + clinic + "\t" +
				"inTS=" + Vista.DatetoFM(inTS) + "\t" +
				"complaint=" + complaint + "\t" +
				"compLong=" + longComplaint + "\t" +
				"status=" + status + "\t" +
				"acuity=" + acuity + "\t" +
				"bed=" + bed + "\t" +
				"provider=" + provider + "\t" +
				"resident=" + resident + "\t" +
				"nurse=" + nurse + "\t" +
				"comment=" + comment + "\t" +
				"outTS=" + Vista.DatetoFM(outTS) + "\t" +
				"delay=" + delay + "\t" +
				"observation=" + observation + "\t" +
				"disposition=" + disposition + "\t" +
				"required=" + required + "\t" +
				"updDiag=" + (updatedDiagnoses ? "1" : "0") + "\t" +
				"loadTS=" + loadTS + "\t";
				
				var seq: int = 0;
				for each (var codedValue: PCECodedValueVO in diagnoses.source) {
					seq++;
					x = x + "diagnosis-" + seq + "=" +
						codedValue.type + "^" +
						codedValue.ien.toString() + "^" +
						codedValue.code + "^" +
						codedValue.label + "^" +
						(codedValue.added ? "1" : "") + "^" +
						(codedValue.remove ? "1" : "") + "^" +
						(codedValue.updated ? "1" : "") + "^" +
						(codedValue.primary ? "1" : "") + "^" +
						codedValue.quantity + "\t";
				}
				return x;
		}
		
		public function copyTo(dest: LogEntryVO): void
		{
			dest.id = this.id;
			dest.site = this.site;
			dest.area = this.area;
			dest.dfn = this.dfn;
			dest.name = this.name;
			dest.ssn = this.ssn;
			dest.dob = this.dob;
			dest.arrival = this.arrival;
			dest.inTS = this.inTS;
			dest.visit = this.visit;
			dest.clinic = this.clinic;
			dest.closed = this.closed;			
			dest.complaint = this.complaint;
			dest.longComplaint = this.longComplaint;
			dest.status = this.status;
			dest.acuity = this.acuity;
			dest.bed = this.bed;
			dest.provider = this.provider;
			dest.resident = this.resident;
			dest.nurse = this.nurse;
			dest.comment = this.comment;
			dest.outTS = this.outTS;
			dest.delay = this.delay;
			dest.observation = this.observation;
			dest.disposition = this.disposition;			
			dest.diagnoses = this.diagnoses;
			dest.required = this.required;
			dest.isStub = this.isStub;
			dest.removeReady = this.removeReady;
			dest.restoreReady = this.restoreReady;
			dest.requireDelay = this.requireDelay;
			dest.requireDiagnosis = this.requireDiagnosis;
			dest.updatedDiagnoses = this.updatedDiagnoses;
			dest.requireDisposition = this.requireDisposition;
			dest.patientFlags = this.patientFlags;
			dest.loadTS = this.loadTS;
		}
		
		public function clear(): void
		{
			id = 0;
			site = 0;
			area = 0;
			
			dfn = "";
			name = "";
			ssn = "";
			dob = "";
			arrival = 0;
			inTS = new Date;
			visit = 0;
			clinic = 0;
			closed = false;
			complaint = "";
			longComplaint = "";
			status = 0;
			acuity = 0;
			bed = 0;
			provider = "";
			resident = "";
			nurse = "";
			comment = "";
			outTS = new Date;
			delay = 0;
			observation = 0;
			disposition = 0;
			diagnoses = new ArrayCollection();
			required = "";
			isStub = false;
			removeReady = false;
			restoreReady = false;
			requireDelay = false;
			requireDiagnosis = false;
			updatedDiagnoses = false;
			requireDisposition = false;
			patientFlags = null;
			loadTS = "";
		}
	}
}