/* LogEditParamsVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the log edit parameters information. 
	 */
	public class LogEditParamsVO implements IValueObject
	{
		/**
		 * The required diagnosis indicator. 
		 */
		public var requireDiagnosis: Boolean;
		/**
		 * The coded diagnosis indicator. 
		 */
		public var codedDiagnosis: Boolean;
		/**
		 * The free diagnosis indicator. 
		 */
		public var freeDiagnosis: Boolean;
		/**
		 * The require disposition indicator. 
		 */
		public var requireDisposition: Boolean;
		/**
		 * The require delay indicator. 
		 */
		public var requireDelay: Boolean;
		/**
		 * The delay minutes value. 
		 */
		public var delayMinutes: int;
		/**
		 * The shift start time. 
		 */
		public var shiftStart: int;
		/**
		 * The shift duration. 
		 */
		public var shiftDuration: int;
		/**
		 * The prompt residents indicator. 
		 */
		public var promptResidents: Boolean;
		/**
		 * The prompt clinics indicator. 
		 */
		public var promptClinics: Boolean;
		/**
		 * The ambulance area. 
		 */
		public var ambulanceArea: int;
		/**
		 * The default room. 
		 */
		public var defaultRoom: int;
		/**
		 * The empty value. Used to hold code for empty value, not editable
		 */
		public var emptyValue: int;	
		/**
		 * The error IEN.
		 */
		public var errorIEN: int;		// entered in error
		/**
		 * The nurse eval IEN.
		 */
		public var nurseEvalIEN: int;	// send to nurse eval clinic
		/**
		 * The left IEN.
		 */
		public var leftIEN: int;		// left without being seen
		
		/**
		 *   Constructor.
		 */
		public function LogEditParamsVO() 
		{
		}
		/**
		 * Returns the string representation of log edit parameters.
		 *  
		 * @return  String  the string of log edit parameters
		 * 
		 */
		public function toString():String
		{
			return "reqDiag=" + (requireDiagnosis ? "1" : "0") + "\t" +
				"codedDiag=" + (codedDiagnosis ? "1" : "0") + "\t" +
				"freeDiagnosis=" + (freeDiagnosis ? "1" : "0") + "\t" +
				"reqDisp=" + (requireDisposition ? "1" : "0") + "\t" +
				"reqDelay=" + (requireDelay ? "1" : "0") + "\t" +
				"minDelay=" + delayMinutes + "\t" +
				"shiftOne=" + shiftStart + "\t" +
				"shiftLen=" + shiftDuration + "\t" +
				"residents=" + (promptResidents ? "1" : "0") + "\t" +
				"clinics=" + (promptClinics ? "1" : "0") + "\t" +
				"ambulance=" + ambulanceArea + "\t" +
				"emptyValue=" + emptyValue + "\t" +
				"errorIEN=" + errorIEN + "\t" +
				"nurseEvalIEN=" + nurseEvalIEN + "\t" +
				"dfltroom=" + defaultRoom + "\t";
		}
	}
}
