/* ColumnSpecVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the column spec entries. 
	 */
	public class ColumnSpecVO implements IValueObject
	{
		/**
		 * The label entry. 
		 */
		public var label: String;
		/**
		 * The attribute entry. 
		 */
		public var attribute: String;
		/**
		 * The header entry. 
		 */
		public var header: String;
		/**
		 * The width entry. 
		 */
		public var width: int;
		/**
		 * The color map object. 
		 */
		public var colorMap: ColorMapVO;
		
		/**
		 *   Constructor.
		 */
		public function ColumnSpecVO() 
		{
		}
		
		/**
		 * Returns the string representation of column spec elements.
		 *  
		 * @return  String  the string of column spec elements
		 * 
		 */
		public function toString():String
		{
			var x: String =
				"label=" + label + "\t" +
				"attribute=" + attribute + "\t" + 
				"header=" + header + "\t" + 
				"width=" + width + "\t" + 
				"colorMap=" + ((colorMap != null) ? colorMap.id : "");
			return x;
		}

	}
}