/* ColorSelectionVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the color selection data. 
	 */
	public class ColorSelectionVO implements IValueObject
	{
		/**
		 * The indicator to ignore. 
		 */
		public var ignore: Boolean = true;
		/**
		 * The text of color selection. 
		 */
		public var text: uint = 0;
		/**
		 * The back of color selection. 
		 */
		public var back: uint = 0xffffff;
				
		/**
		 *   Constructor.
		 */
		public function ColorSelectionVO() 
		{
		}
		
		/**
		 * Returns the string representation of color selection parameters.
		 *  
		 * @return  String  the string of color selection parameters
		 * 
		 */
		public function toString(): String
		{
			// in the string form, the first comma piece is 1 if color should be used
			var x: String =
				(ignore ? "0" : "1") + "," +
				"0x" + text.toString(16) + "," +
				"0x" + back.toString(16) + ",";
			return x;
		}
	}
}
