/* ColorMapVO.as */

package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	/**
	 * Holds the color map information. 
	 */
	public class ColorMapVO implements IValueObject
	{
		/**
		 * The id of color map. 
		 */
		public var id: String;
		/**
		 * The name of color map. 
		 */
		public var name: String;
		/**
		 * The type of color map. 
		 */
		public var type: String;
		/**
		 * The used indicator of color map. 
		 */
		public var used: Boolean = false;
		/**
		 * The array of matches for color map. 
		 */
		public var matches: ArrayCollection;  // array of ColorMatchVO
		
		/**
		 *   Constructor.
		 */
		public function ColorMapVO() 
		{
		}
	}
}