/* CodeSelectionVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	/**
	 * Holds the code selection information.
	 */
	public class CodeSelectionVO implements IValueObject
	{
		/**
		 * The id of code selection.
		 */
		public var id: int = 0;
		/**
		 * The name.
		 */
		public var name: String = "";
		/**
		 * The display name.
		 */
		public var displayName: String = "";
		/**
		 * The abbreviation.
		 */
		public var abbreviation: String = "";
		/**
		 * The flag.
		 */
		public var flag: String = "";
		/**
		 * The inactive indicator.
		 */
		public var inactive: Boolean;
		/**
		 * The national entry.
		 */
		public var national: String = "";

		/**
		 *   Constructor.
		 */
		public function CodeSelectionVO() 
		{
		}
		/**
		 * Returns the string representation of code selection parameters.
		 *  
		 * @return  String  the string of code selection parameters
		 * 
		 */
		public function toString(): String
		{
			// in the string form, the first comma piece is 1 if Code should be used
			var x: String =
				"id=" + id + "\t" +
				"nm=" + name + "\t" +
				"show=" + displayName + "\t" +
				"abbr=" + abbreviation + "\t" +
				"flag=" + flag + "\t" +
				"inact=" + (inactive ? "1" : "0") + "\t" + 
				"natl=" + national + "\t";
			return x;
		}
	}
}