package gov.va.med.edp.view.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import com.adobe.cairngorm.control.CairngormEventDispatcher;
	
	import flash.events.MouseEvent;
	
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.LogEntryVO;
	
	import mx.containers.HBox;
	import mx.containers.VBox;
	import mx.controls.Button;
	import mx.controls.ProgressBar;
	import mx.controls.ProgressBarDirection;
	import mx.controls.ProgressBarMode;
	import mx.core.Container;
	import mx.events.StateChangeEvent;
	import mx.rpc.IResponder;
	import mx.states.SetProperty;
	import mx.states.SetStyle;
	import mx.states.State;
	import mx.styles.StyleManager;
	import mx.binding.utils.BindingUtils;
	
	/**
	 * Class for worksheet widget.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class WorkSheetWidget extends VBox
	{		
	
		[Bindable]
		/**
		 * The tracking model locator containing the worksheet data. 
		 */
		protected var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		
		private var _event:CairngormEvent;
		
		/**
		 * The tracking model locator containing the worksheet data. 
		 */
		protected static const INITIALIZED: String = "INITIALIZED";
		protected static const INITIALIZING: String = "INITIALIZING";
		protected static const EXECUTING: String = "EXECUTING";
		protected static const EDITING: String = "EDITING";
		protected static const LOADED: String = "LOADED";
		protected static const LOADING: String = "LOADING";
		protected static const SAVED: String = "SAVED";
		protected static const SAVING: String = "SAVING";
		protected static const RESET: String = "RESET";
		protected static const ERROR: String = "ERROR";
		protected static const NO_RESULTS: String = "NO_RESULTS";
		protected static const LOAD_MESSAGE: String = "Click Load to retrieve patient data.";
				
		/**
		 * The progess bar control on the widget. 
		 */
		protected var progressBar:ProgressBar;
		
		/**
		 * The reset worksheet widget event. 
		 */
		protected var resetEvent:WorkSheetWidgetEvent;		
		/**
		 * The initializing worksheet widget event. 
		 */
		protected var initializingEvent:WorkSheetWidgetEvent;
		/**
		 * The initialized worksheet widget event. 
		 */
		protected var initializedEvent:WorkSheetWidgetEvent;
		/**
		 * The loading worksheet widget event. 
		 */
		protected var loadingEvent:WorkSheetWidgetEvent;
		/**
		 * The loaded worksheet widget event. 
		 */
		protected var loadedEvent:WorkSheetWidgetEvent;
		/**
		 * The executing worksheet widget event. 
		 */
		protected var executingEvent:WorkSheetWidgetEvent;
		/**
		 * The editing worksheet widget event. 
		 */	
		protected var editingEvent:WorkSheetWidgetEvent;
		/**
		 * The error worksheet widget event. 
		 */	
		protected var errorEvent:WorkSheetWidgetEvent;
		/**
		 * The saved worksheet widget event. 
		 */	
		protected var savedEvent:WorkSheetWidgetEvent;		
		/**
		 * The saving worksheet widget event. 
		 */	
		protected var savingEvent:WorkSheetWidgetEvent;
		
		/**
		 * The rpc callback responder. 
		 */	
		protected var callbacks : IResponder;

		/**
		 * The worksheet widget name. 
		 */	
		protected var widgetTitle:String = "WorkSheetWidget";
		
		/**
		 * The light weight indicator. 
		 */	
		protected var isLightWeight:Boolean = false;
		
		/**
		 * The saved log entry object. 
		 */	
		protected var savedEntry:LogEntryVO;
		
		/**
		 * Base class for worksheet widgets.
		 * @param event  the cairngorm worksheet event. Set to null.
		 * 
		 */
		public function WorkSheetWidget(event:CairngormEvent = null)
		{
			super();
			//initEvents();
			
		}
		
		/**
		 * Initializes various events.
		 * @param event  the cairngorm worksheet event.
		 * 
		 */
		protected function initEvents(event:CairngormEvent):void
		{
			initializingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.INITIALIZING,event.type);
			initializedEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.INITIALIZED,event.type);
			resetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.RESET,event.type);
			loadedEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.LOADED,event.type);
			loadingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.LOADING,event.type);
			executingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.EXECUTING,event.type);
			errorEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.ERROR,event.type);
		}
		
		/**
		 * Registers various listeners for widget state changes.
		 */
		protected function registerListeners():void
		{
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.INITIALIZING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.INITIALIZED,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.EXECUTING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.LOADING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.LOADED,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.SAVING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.SAVED,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.RESET,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.ERROR,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.NO_RESULTS,handleWidgetStateChange);
			BindingUtils.bindSetter(currentEntry,model,getPropertyChainFromValue("logEdit.entry"));

		}
		
		/**
		 * Gets the property chain from the value.
		 * 
		 * @param val  the value.
		 * @return Array  the array of property chain values.
		 */
		protected function getPropertyChainFromValue(val:String):Array
		{			
			var propertyChain:Array = new Array();			
			var delimiter:String = ".";			
			
			if (val != null && val.length > 0) 
			{							
				propertyChain = val.split(delimiter);		 				
			}
			
			return propertyChain;			
		}
		
		/**
		 * Initializes the events and registers the listeners
		 * 
		 * @param event  the cairngorm event. Set to null.
		 * @param title  the title string. Set to null.
		 * @param lightWeight  the boolean indicator. Set to false.
		 * 
		 */
		public function init(event:CairngormEvent = null,
							 title:String = null,
							 lightWeight:Boolean = false): void
		{
					
			isLightWeight = lightWeight;
			
			//if(!isLightWeight) {
			
				initEvents(event);
			
				widgetTitle = title;
			
				initializingEvent.dispatch();
			
				createProgressBar();
			
				registerListeners()
			
				styleName = "worksheetWidget";
			
				if (event != null) 
				{
					_event = event;
					CairngormEventDispatcher.getInstance().addEventListener(event.type,execute);
				}
			
				this.callbacks = new mx.rpc.Responder(saveSuccess, saveFailure);
			
				if (event is AbstractNotificationEvent) {
					(event as AbstractNotificationEvent).callbacks = this.callbacks;
				} 
			
			//} else {
				
				//widgetTitle = title;
			//	createProgressBar();
				//styleName = "worksheetWidget";
				//if (event != null) 
				//{
					//_event = event;
				//}
				
		//	}
			
		}
		
		/**
		 * Dispatches the loaded event on successful execution of the command
		 * 
		 * @param data  the object returned from successful executing of the command.
		 * 
		 */
		protected function  saveSuccess(data:Object): void {
			loadedEvent.dispatch();
		}
		
		/**
		 * Dispatches the error event on failure in execution of the command
		 * 
		 * @param info  the error object returned from failed execution of the command.
		 * 
		 */
		protected function  saveFailure(info:Object): void {
			errorEvent.dispatch();
		}
			
		/**
		 * Called when the widget has executed its RPC call.
		 * 
		 * @param event  the cairngorm event. 
		 */
		protected function execute(event : CairngormEvent):void
		{
			executingEvent.dispatch();
		}
		
		/**
		 * This method makes styles "width", "height", "percentWidth", "percentHeight", "x", "y" and "visible"
		 * valid from css.
		 * 
		 * @param styleProp  the style property
		 */
		override public function styleChanged(styleProp:String):void{
			super.styleChanged(styleProp);
			if(!styleProp || styleProp == "styleName"){
				//if runtime css swap or direct change of stylename
				var classSelector:Object = StyleManager.getStyleDeclaration("." + styleName);
				if(classSelector != null){
					applyProperties(classSelector, ["width", "height", "percentWidth", "percentHeight", "x", "y", "visible"]);
				}
			}
		}
		
		private function applyProperties(styleObj:Object, arr:Array):void{
			for each (var item:String in arr){
				var prop:Object = styleObj.getStyle(item);
				if(prop != null) this[item] = prop;
			}
		}
		
		/**
		 * This will build the GUI components associated with this widget.
		 */
		protected function build():void
		{
			createNorthPanel();
			createCenterPanel();
			addChild(progressBar);
			
			initializedEvent.dispatch();
			
		}

		/**
		 * Returns the load/save event associated with this widget.
		 * @return the load/save event associated with this widget
		 * 
		 */
		public function get event():CairngormEvent
		{
			return _event;
		}

		/**
		 * Sets the load/save event associated with this widget.
		 * @param value - the load/save event associated with this widget.
		 * 
		 */
		public function set event(value:CairngormEvent):void
		{
			_event = value;
		}

		/**
		 *  This creates the north component associated with this 
		 *  widget.  This should be overriden in a child class.
		 * 
		 */
		protected function createNorthPanel():void
		{
			
		}
		
		/**
		 *  This creates the center component associated with this 
		 *  widget.  This should be overriden in a child class.
		 */
		protected function createCenterPanel():void
		{
			
		}
		
		/**
		 *  This creates the progress bar. 
		 */
		protected function createProgressBar():void
		{
			if (progressBar == null) 
			{
				progressBar = new ProgressBar();
				progressBar.percentWidth = 100;
				progressBar.label = "START";
				progressBar.minimum = 0;
				progressBar.maximum = 100;
				progressBar.direction = ProgressBarDirection.RIGHT;
				progressBar.mode = ProgressBarMode.MANUAL;
				progressBar.labelPlacement = "center";
				progressBar.styleName = "worksheetWidgetProgressBar";
				progressBar.setStyle("barColor", "gray");
			}
		}
				
		private function handleWidgetStateChange(event:WorkSheetWidgetEvent) :void
		{
			//trace("event.type " + this.event.type + " event.widgetDataType " + event.widgetDataType);
			
			if (event.widgetDataType != this.event.type) {				
				return;				
			}
			
			if (event.type == INITIALIZED) {
				progressBar.setProgress(0, 100);
				progressBar.label = LOAD_MESSAGE;
				progressBar.setStyle("barColor", "gray");
				widget_initialized();
			} else if (event.type == INITIALIZING) {
				progressBar.setProgress(50, 100);
				progressBar.label = INITIALIZING;
				progressBar.setStyle("barColor", "yellow");
			} else if (event.type == EXECUTING) {
				progressBar.setProgress(35, 100);
				progressBar.label = EXECUTING;
				progressBar.setStyle("barColor", "yellow");
			} else if (event.type == LOADED)	{
				trace("LOADED event.widgetDataType " + event.widgetDataType);
				progressBar.setProgress(100, 100);
				progressBar.label = LOADED;
				progressBar.setStyle("barColor", "green");
				loaded();
			} else if (event.type == LOADING) {
				progressBar.setProgress(75, 100);
				progressBar.label = LOADING;
				progressBar.setStyle("barColor", "yellow");
			} else if (event.type == SAVED) {
				progressBar.setProgress(100, 100);
				progressBar.label = SAVED;
				progressBar.setStyle("barColor", "green");
			} else if (event.type == SAVING)	{
				progressBar.setProgress(75, 100);
				progressBar.label = SAVING;
				progressBar.setStyle("barColor", "yellow");
			} else if (event.type == RESET)	{
				progressBar.setProgress(0, 100);
				progressBar.label = LOAD_MESSAGE;
				progressBar.setStyle("barColor", "gray");
			} else if (event.type == ERROR)	{
				progressBar.setProgress(100, 100);
				progressBar.label = ERROR;
				progressBar.setStyle("barColor", "red");
			}  else if (event.type == NO_RESULTS)	{
				trace("EMPTY event.widgetDataType " + event.widgetDataType);
				progressBar.setProgress(0, 100);
				progressBar.label = "This patient has no data.";
				progressBar.setStyle("barColor", "gray");
			}							
		}
		
		/**
		 * Save the current entry.
		 * 
		 * @param entry  the log entry VO object. 
		 */
		protected function currentEntry(entry: LogEntryVO): void
		{
			if (entry == null) return;
			
			if (savedEntry == null)
			{
				savedEntry = new LogEntryVO();
				entry.copyTo(savedEntry);
			}
			
			if(entry.dfn != savedEntry.dfn)
			{
				entryChanged();
				
				entry.copyTo(savedEntry);
			}
		}
		
		/**
		 * Resets the entries.
		 * 
		 */
		protected function entryChanged():void			
		{
			reset();
		}
		
		/**
		 * Resets the input values.
		 * 
		 */
		protected function reset():void
		{			
		}
		
		/**
		 * Used for post processing of widget..
		 * 
		 */
		protected function loaded():void
		{			
		}
		
		/**
		 * Used for post processing of widget initialized.
		 * 
		 */
		protected function widget_initialized():void
		{			
		}
	}
}