package gov.va.med.edp.view.worksheet
{
	import gov.va.med.edp.control.DetailsEvent;
	import gov.va.med.edp.control.GetVitalsEvent;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.cpe.view.DeviationRenderer;
	import gov.va.med.edp.factory.WorkSheetFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.util.DateMath;
	import gov.va.med.edp.view.worksheet.WorkSheetPanel;
	
	import mx.binding.utils.BindingUtils;
	import mx.containers.HBox;
	import mx.controls.DataGrid;
	import mx.controls.Label;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.ClassFactory;
	import mx.formatters.DateFormatter;

	/**
	 * Utility class for worksheet data grid access based on events. 
	 */
	public class WorkSheetUtil
	{		
		[Bindable]
		private static var model: TrackingModelLocator = TrackingModelLocator.getInstance();						
		private var lblStartDate:Label = new Label();		
		private var lblStopDate:Label = new Label();		
		private var formatDateTime:DateFormatter;		
		private static var instance: WorkSheetUtil;
		
		/**
		 * Constructor for the WorkSheetDataGridUtil.
		 *  
		 */
		public function WorkSheetUtil()
		{
			
			if (instance != null) {
				throw new Error("Only one TrackingModelLocator should be instantiated.");
			}
			
			if (formatDateTime == null) {
				formatDateTime = new DateFormatter();
				formatDateTime.formatString = "EEEE, MMMM D, YYY";	
			}
			
			BindingUtils.bindSetter(dateRangeChanged, model, "priorLabsInterval");						
		}
		
		/**
		 * Singleton method for accessing this util class. 
		 * @return WorkSheetUtil
		 * 
		 */
		public static function getInstance(): WorkSheetUtil
		{
			if (instance == null) {
				instance = new WorkSheetUtil();
			}
			return instance;
		}

		private function dateRangeChanged(interval: int): void
		{		
			var now:Date = new Date();
			var stop:Date = DateMath.subWeeks(now, interval);
			// Actually it is this stop = DateMath.addDays(now, 1);														
			var stopDate:String = formatDateTime.format(now);
			lblStopDate.text = stopDate;			
			var startDate:String = formatDateTime.format(stop);
			lblStartDate.text = startDate;		
			
		}
		
		private function getPropertyChainFromValue(val:String):Array
		{
			
			var propertyChain:Array = new Array();			
			var delimiter:String = ".";			
			
			if (val != null && val.length > 0) 
			{							
				propertyChain = val.split(delimiter);		 				
			}
			
			return propertyChain;			
		}
		
		/**
		 * Get the control bar header determined by the event type.
		 * @param type - The type of grid requested. 
		 * @param defaultHeader - Default header for the grid.
		 * @return The header HBox.
		 * 
		 */
		public function getWidgetControlBarHeader(type:String = null, defaultHeader:String = null): HBox
		{
			
			var header:HBox = new HBox()
				
			var lblDefault:Label = new Label();
			if (defaultHeader != null) {
				lblDefault.text = defaultHeader;
			} else {
				lblDefault.text = "TBD";
			}
			
			header = new HBox();
			header.percentWidth = 100;
			header.setStyle("horizontalAlign","center");
			
			if (type == LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS) {
											
				var lblFrom:Label = new Label();
				lblFrom.text = "From :";
				lblFrom.setStyle("fontWeight","bold");
				lblFrom.setStyle("fontSize","10");
				lblFrom.setStyle("color","#FF1919");
				
				var lblTo:Label = new Label();				
				lblTo.text = "To :";
				lblTo.setStyle("fontWeight","bold");
				lblTo.setStyle("fontSize","10");
				lblTo.setStyle("color","#FF1919");
				
				header.addChild(lblFrom);
				header.addChild(lblStartDate);
				header.addChild(lblTo);
				header.addChild(lblStopDate);

				
			} else if (type == DetailsEvent.EVENT_DETAILS_PLIST) {
				header.addChild(lblDefault);				
			} else if (type == DetailsEvent.EVENT_DETAILS_MEDS) {
				header.addChild(lblDefault);	
			} else if (type == GetVitalsEvent.EVENT_GET_VITALS) {
				header.addChild(lblDefault);
			} else {
				header.addChild(lblDefault);
			}
			
			return header;
		}
		


		/**
		 * Get the datagrid determined by the event type.
		 * 
		 * @param type - The type of grid requested.
		 * @return The specified data grid.
		 * 
		 */
		public function getDataGrid(type:String): DataGrid
		{
			
			var datagrid:DataGrid = new DataGrid();
			datagrid.percentHeight = 100;
			datagrid.percentWidth = 100;
			
			var columns:Array = new Array();
			
			if (type == DetailsEvent.EVENT_DETAILS_MEDS) {
											
				datagrid.dataProvider = model.activeMeds;
				
				var columnName:DataGridColumn = new DataGridColumn();
				columnName.headerText = 'Name';
				columnName.dataField="name";
				columnName.width = 160;
				
				var columnSig:DataGridColumn = new DataGridColumn();
				columnSig.headerText = 'Sig';
				columnSig.dataField="sig";
				columnSig.width = 200; 
				
				var columnStatus:DataGridColumn = new DataGridColumn();
				columnStatus.headerText = 'Status';
				columnStatus.dataField="status";
				columnStatus.width = 80; 
				
				columns.push(columnName);
				columns.push(columnSig);
				columns.push(columnStatus);
				
				datagrid.columns = columns;
				
			} else if (type == DetailsEvent.EVENT_DETAILS_PLIST) {
				
				datagrid.dataProvider = model.activeProblems;
				
				var columnNamePlist:DataGridColumn = new DataGridColumn();
				columnNamePlist.headerText = 'Name';
				columnNamePlist.dataField="name";
				columnNamePlist.width = 160;
				
				var columnICD:DataGridColumn = new DataGridColumn();
				columnICD.headerText = 'ICD';
				columnICD.dataField="icd";
				columnICD.width = 80; 
				
				columns.push(columnNamePlist);
				columns.push(columnICD);
				
				datagrid.columns = columns;
				
			} else if (type == LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS) {
				
				datagrid.dataProvider = model.labVOList;
				
				var columnTName:DataGridColumn = new DataGridColumn();
				columnTName.headerText = 'Test Name';
				columnTName.dataField="testName";
				columnTName.width = 140;
				
				var columnResult:DataGridColumn = new DataGridColumn();
				columnResult.headerText = 'Result';
				columnResult.dataField="result";
				columnResult.width = 50; 
				
				var columnUnits:DataGridColumn = new DataGridColumn();
				columnUnits.headerText = 'Units';
				columnUnits.dataField="units";
				columnUnits.width = 40; 
				
				var columnHigh:DataGridColumn = new DataGridColumn();
				columnHigh.headerText = 'High';
				columnHigh.dataField="high";
				columnHigh.width = 50;
				
				var columnLow:DataGridColumn = new DataGridColumn();
				columnLow.headerText = 'Low';
				columnLow.dataField="low";
				columnLow.width = 50;
				
				var columnDev:DataGridColumn = new DataGridColumn();
				columnDev.headerText = 'Alert';
				columnDev.dataField="deviation";
				columnDev.width = 40;			
				columnDev.itemRenderer = new ClassFactory(gov.va.med.edp.cpe.view.DeviationRenderer);
				
				var columnCTS:DataGridColumn = new DataGridColumn();
				columnCTS.headerText = 'Date Collected';
				columnCTS.dataField="collectedTS";
				columnCTS.width = 80;
				
				var columnCRS:DataGridColumn = new DataGridColumn();
				columnCRS.headerText = 'Date Resulted';
				columnCRS.dataField="resultedTS";
				columnCRS.width = 80;
					
				columns.push(columnTName);
				columns.push(columnResult);
				columns.push(columnUnits);
				columns.push(columnHigh);
				columns.push(columnLow);
				columns.push(columnDev);
				columns.push(columnCTS);
				columns.push(columnCRS);
				
				datagrid.columns = columns;
				
			} else if (type == GetVitalsEvent.EVENT_GET_VITALS) {
				
							
				//datagrid.dataProvider = model.vitalsModel.vitals;
				datagrid.dataProvider = model.vitalsModel.vitals;
				
				var columnTime:DataGridColumn = new DataGridColumn();
				columnTime.headerText = 'Time';
				columnTime.dataField="time";
				columnTime.width = 140;
				
				var columnTemp:DataGridColumn = new DataGridColumn();
				columnTemp.headerText = 'Temp(f)';
				columnTemp.dataField="t";
				columnTemp.width = 40; 
				
				var columnPulse:DataGridColumn = new DataGridColumn();
				columnPulse.headerText = 'Pulse';
				columnPulse.dataField="p";
				columnPulse.width = 40; 
				
				var columnResp:DataGridColumn = new DataGridColumn();
				columnResp.headerText = 'Resp';
				columnResp.dataField="r";
				columnResp.width = 40;
				
				var columnBP:DataGridColumn = new DataGridColumn();
				columnBP.headerText = 'B/P';
				columnBP.dataField="bp";
				columnBP.width = 40;
				
				var columnWeight:DataGridColumn = new DataGridColumn();
				columnWeight.headerText = 'Wt(lbs)';
				columnWeight.dataField="wt";
				columnWeight.width = 40;			
				
				
				var columnHeight:DataGridColumn = new DataGridColumn();
				columnHeight.headerText = 'Ht(in)';
				columnHeight.dataField="ht";
				columnHeight.width = 40;
				
				var columnPain:DataGridColumn = new DataGridColumn();
				columnPain.headerText = 'Pain';
				columnPain.dataField="pn";
				columnPain.width = 40;
				
				columns.push(columnTime);
				columns.push(columnTemp);
				columns.push(columnPulse);
				columns.push(columnResp);
				columns.push(columnBP);
				columns.push(columnWeight);
				columns.push(columnHeight);
				columns.push(columnPain);
				
				datagrid.columns = columns;
				
			}

			return datagrid;
		}
		
		/**
		 * Generates the worksheet preview.
		 * 
		 * @param xml  the XML input to be used to generate the preview. 
		 */
		public function generateWorkSheetPreview(xml:XML):WorkSheetPanel
		{
			var workSheetPanel:WorkSheetPanel;			
			var workSheetModel:WorkSheetModel; 
			
			if(xml != null) 
			{
				workSheetModel = new WorkSheetModel(WorkSheetFactory.buildWorkSheet(xml));
				
				if (workSheetModel != null) 
				{
					workSheetPanel = new WorkSheetPanel(workSheetModel,true);	
				} else {
					throw new Error("Attempted to generate a workseet with a null model.");
				}
			
	
			} else {
				throw new Error("Attempted to generate a workseet with null xml.");
			}
			
			
			
			
			return workSheetPanel;
		}
	}
}