package gov.va.med.edp.view.worksheet
{
	import gov.va.med.edp.control.worksheet.WorkSheetStatusEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.ISection;
	import gov.va.med.edp.model.worksheet.IWorkSheet;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.model.worksheet.WorkSheetModel;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	
	import mx.collections.ArrayCollection;
	import mx.containers.Panel;
	import mx.containers.VBox;
	import mx.validators.Validator;
	
	/**
	 * Panel that contains the worksheet, responsible for the creation of all children
	 * artifacts. 
	 * @author useruseruser12
	 * 
	 */
	public class WorkSheetPanel extends Panel
	{
		
		[Bindable]
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();		
		/*
		 * Worksheet related artifacts.
		 */
		[Bindable]
		private var workSheetModel:WorkSheetModel;	
		private var sectionsContainer:VBox;
		
		private var isLightWeight:Boolean = false;
		
		/**
		 * Used for validations of input field entries.
		 */
		public var validators: ArrayCollection = new ArrayCollection();
		
		/**
		 * Used to hold worksheet name.
		 */
		public var worksheetName:String;
		
		/**
		 * The reset worksheet status event.
		 */	
		protected var resetEvent:WorkSheetStatusEvent;
		/**
		 * The initializing worksheet status event.
		 */	
		protected var initializingEvent:WorkSheetStatusEvent;
		/**
		 * The initialized worksheet status event.
		 */	
		protected var initializedEvent:WorkSheetStatusEvent;
		/**
		 * The loading worksheet status event.
		 */	
		protected var loadingEvent:WorkSheetStatusEvent;
		/**
		 * The loaded worksheet status event.
		 */	
		protected var loadedEvent:WorkSheetStatusEvent;
		/**
		 * The executing worksheet status event.
		 */	
		protected var executingEvent:WorkSheetStatusEvent;
		/**
		 * The error worksheet status event.
		 */	
		protected var errorEvent:WorkSheetStatusEvent;
		/**
		 * The added worksheet status event.
		 */	
		protected var addedEvent:WorkSheetStatusEvent;
				
		/**
		 * Constructor.
		 * 
		 * @param model - The worksheet model.
		 * @param lightWeight - Whether or not to bind data, used for preview.
		 */
		public function WorkSheetPanel(model:WorkSheetModel,lightWeight:Boolean = false)
		{
			super();
			this.styleName = "worksheetPanel";
			workSheetModel = model;
			
			worksheetName = workSheetModel.getName();
			
			initEvents();

			isLightWeight = lightWeight;
			
			initializingEvent.dispatch();

			creationWorkSheet();
			
			initializedEvent.dispatch();

		}
		
		/**
		 * Initializes various worksheet status events.
		 */	
		protected function initEvents():void
		{
			// title - worksheet name.
			initializingEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.INITIALIZING,worksheetName);
			initializedEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.INITIALIZED,worksheetName);
			resetEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.RESET,worksheetName);
			loadedEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.LOADED,worksheetName);
			loadingEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.LOADING,worksheetName);
			executingEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.EXECUTING,worksheetName);
			errorEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.ERROR,worksheetName);
			addedEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.ADDED,worksheetName);
		}
			
		
		private function creationWorkSheet():void
		{
			
			createSectionContainer();
			
			var workSheet:IWorkSheet = workSheetModel;
			
			var workSheetName:String = workSheet.getName();
			
			title = workSheetName;
			label = workSheetName;
						
			
			var sections:ArrayCollection = workSheet.getSections();
			
			var sortedSections:ArrayCollection = sortSections(sections);
			
			//for each( var section:ISection in sections )
			for each( var section:ISection in sortedSections )
			{
				createSection(section);	
			}
			
			addChild(sectionsContainer);
			
		}
		
		private function createSection(section:ISection):void
		{									
			var sectionModel:SectionModel = (section as SectionModel);						
			var sectionPanel:SectionPanel = new SectionPanel(this,sectionModel,isLightWeight);				
			sectionsContainer.addChild(sectionPanel);			
		}
		
		private function createSectionContainer():void
		{
			sectionsContainer = new VBox();
			sectionsContainer.styleName = "worksheetSectionContainer";
			sectionsContainer.percentWidth=100;			
			sectionsContainer.percentHeight=100;
		}
		
		private function sortSections(sections:ArrayCollection):ArrayCollection
		{
			var sectionVO:SectionModel;
			var length:int = sections.length;
			var sorted:ArrayCollection = new ArrayCollection();
			var index:int = 0;
			var i:int = 0;
			
			var x:int = 0;
			
			//trace("In section Size " + length);
			
			// Workaround, arraycollection needs position prior to adding
						
			for (i; i < length; i++) 
			{
				sectionVO = sections.getItemAt(i) as SectionModel;							
				sorted.addItemAt(sectionVO,i);
			}
			
			i = 0;
			
			for (i; i < sorted.length; i++) 
			{
				sectionVO = sections.getItemAt(i) as SectionModel;	
				//trace("Before section " + i + " val " + sectionVO.getSectionVO().name);
			}
			
			i = 0;
			
			for (i; i < sorted.length; i++)
			{
				sectionVO = sections.getItemAt(i) as SectionModel;	
				//index = parseInt(sectionVO.getSectionVO().sequence);
				index = sectionVO.getSectionVO().sequence;
				//trace("Setting section " + sectionVO.getSectionVO().name + " at " + index);
				sorted.setItemAt(sectionVO,index);
			}
			
			length  = sorted.length;
			
			//trace("Out section Size " + length);
			
			for (x; x < length; x++) 
			{
				sectionVO = sorted.getItemAt(x) as SectionModel;
				
				//trace("After section " + x + " val " + sectionVO.getSectionVO().name);
			}
			
			return sorted;
			
		}
		
		/**
		 * Removes the validator from the validators list. 
		 * 
		 * @param validator - The validator to remove.
		 * 
		 */
		public function removeValidator(validator:Validator):void
		{
			if(validator != null) {
			
				var index:int = validators.getItemIndex(validator); 
			
				if(index != -1) { // Exists
					validators.removeItemAt(index);	
				}
			}
		}
		
		/**
		 * Adds the validator from the validators list.
		 * 
		 * @param validator - The validator to add.
		 * 
		 */
		public function addValidator(validator:Validator):void
		{
			if(validator != null) {
				
				if(!validators.contains(validator)) {
					validators.addItem(validator);	
				}
				
			}
		}
		

		/**
		 * Gets validators array.
		 * 
		 * @return Array if validators.
		 * 
		 */
		public function getValidators():Array
		{
			var vals:Array;
			
			if(validators != null) {
				
				vals = validators.source;
				
			} else {
				
				vals = [];
			
			}
						
			return vals;
		}
		
		/**
		 * Dispatches the worksheet status added event.
		 * 
		 */	
		public function added():void
		{
			addedEvent.dispatch();
		}
		
	}
}