package gov.va.med.edp.view.worksheet
{
	import mx.controls.DataGrid;
	import mx.controls.dataGridClasses.DataGridColumn;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.util.PrintUtil;
	import mx.printing.FlexPrintJob;
	import gov.va.med.edp.view.worksheet.WorkSheetUtil;
	/**
	 * Widget for displaying and printing data grid models.
	 *  
	 * @author useruseruser12
	 * 
	 */
	public class WorkSheetDataGridWidget extends LoadWorkSheetWidget
	{
		private var _datagrid:DataGrid;
		
		/**
		 * This widget is used for loading and viewing grid data.
		 * @param printable - Wether or not this widget can be printed.
		 * @param loadEvent - Event to dispatch the load call.
		 */
		public function WorkSheetDataGridWidget(printable:Boolean=true,
												loadEvent:CairngormEvent = null)
		{
			super(printable,loadEvent);
		}
	
		/**
		 * Initializes and builds the data grid widget.
		 * 
		 * @param event  the event to be used at initialization. Set to null.
		 * @param title  the title to be used at initialization. Set to null.
		 * @param lightWeight  the light weight indicator. Set to false.
		 * 
		 */
		override public function init(event:CairngormEvent = null, title:String = null, lightWeight:Boolean = false): void
		{
			super.init(event,title,lightWeight);
			build();
		}
		
		/**
		 * Getting for accessing the datagrid.
		 * @return datagrid - containing the data.
		 * 
		 */
		public function get datagrid():DataGrid
		{
			return _datagrid;
		}

		/**
		 * Setter for changing the datagrid.
		 * @param value - datagrid containing the data.
		 * 
		 */
		public function set datagrid(value:DataGrid):void
		{
			_datagrid = value;
		}
		
		/**
		 * This will build the GUI components associated with this widget.
		 */
	    override protected function build():void
		{			
			super.build();
		}
		
		/**
		 * Calls build data grid.
		 * 
		 */
		override protected function createCenterPanel():void
		{
			buildDataGrid();
		}
				
		private function buildDataGrid():void
		{			
			datagrid = WorkSheetUtil.getInstance().getDataGrid(event.type);			
			addChild(datagrid);
		}

		/**
		 * Prints the data grid. Uses the flex print job.
		 * 
		 */
		override protected function print():void
		{			
			printJob = new FlexPrintJob();
			if (printJob.start() != true) return;
			PrintUtil.printDataGrid(printJob,datagrid.columns, datagrid.dataProvider, widgetTitle);
			printJob.send();
			
		}
		
		/**
		 *  Resets the buttons and dispatches the reset event.
		 * 
		 */
		override protected function reset():void
		{
			//resetEvent.widgetDataType = event.type;
			resetEvent.dispatch();
			loadButton.enabled = true;
			printButton.enabled = false;
			clearButton.enabled = false;
		}
	}
}