package gov.va.med.edp.view.worksheet
{
	import com.adobe.cairngorm.control.CairngormEvent;
	import com.adobe.cairngorm.control.CairngormEventDispatcher;
	
	import gov.va.med.edp.control.AbstractNotificationEvent;
	import gov.va.med.edp.control.UpdateVitalsEvent;
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	import gov.va.med.edp.cpe.view.vitals.BloodPressureValidator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.containers.Form;
	import mx.containers.FormItem;
	import mx.containers.HBox;
	import mx.controls.NumericStepper;
	import mx.controls.Spacer;
	import mx.controls.TextInput;
	import mx.rpc.IResponder;
	import mx.validators.Validator;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import mx.core.UIComponent;
	import gov.va.med.edp.vo.VitalsVO;
	import mx.binding.utils.BindingUtils;

	/**
	 * Saves vitals information for a given patient.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class VitalsSaveWidget extends SaveWorksheetWidget
	{
		/**
		 * The form container.
		 */
		protected var formContainer:HBox;
		private var validators: Array = [];
		private var bpValidator:BloodPressureValidator = new BloodPressureValidator();
		
		private var bpTextInput:TextInput;
		private var tfNumberStepper:NumericStepper;
		private var pNumberStepper:NumericStepper;
		private var rrNumberStepper:NumericStepper;
		private var htNumberStepper:NumericStepper;
		private var wtNumberStepper:NumericStepper;
		private var painNumberStepper:NumericStepper;
		
		private static const SAVE_MESSAGE: String = "Click Save to update patient data.";
		
		/**
		 * Saves vitals information for a given patient.  
		 */
		public function VitalsSaveWidget()
		{
			super();			
		}
		
		private function initValidators():void
		{
			
			bpValidator = new BloodPressureValidator();
			bpValidator.required = true;
			bpValidator.source = bpTextInput;
			bpValidator.property = "text";			
		}
		
		/**
		 * 
		 * Initialises the save component.
		 * 
		 * @param title Title of the section.
		 * @param lightWeight For preview or not.
		 * 
		 */
		public function initWidget(title:String = null,
							 lightWeight:Boolean = false): void
		{
			
			isLightWeight = lightWeight;
						
			initEvents(event);
			
			widgetTitle = title;
			
			initializingEvent.dispatch();
			
			createProgressBar();
			
			registerListeners()
			
			styleName = "worksheetWidget";
			
			this.event = new UpdateVitalsEvent(UpdateVitalsEvent.EVENT_SAVE_VITALS);
			CairngormEventDispatcher.getInstance().addEventListener(event.type,execute);

			
			this.callbacks = new mx.rpc.Responder(saveSuccess, saveFailure);
			
			if (event is AbstractNotificationEvent) {
				(event as AbstractNotificationEvent).callbacks = this.callbacks;
			}
			
			
			build();
			
		}
		
		/**
		 * This is to reset fields.
		 * 
		 */
		override protected function reset():void
		{
			//CLEAR FIELDS
			clearFields();
			cancelEdit();
			resetEvent.dispatch();
		}
		
		/**
		 *  Cancels the edits that are currently waiting to be processed.
		 */
		public function cancelEdit(): void
		{
			model.vitalsSaved = false;
			model.vitalsVO = new VitalsVO();
		}
		
		/**
		 *  Saves the edits that are currently waiting to be processed after validating the fields.
		 */
		protected override function save(): void
		{
			
			validators.push(bpValidator);
			
			
			var results: Array = Validator.validateAll(validators);
			
			if (results.length == 0) {
				
				resetEvent.dispatch(); // POST A CLEAR FOR VITALS MIGHT CAUSE ISSUES WITH INSTANT REFRESH OF VALUES
				
				//clearGridSelection(); // POST A CLEAR FOR VITALS
				
				this.event.dispatch();
				
				clearFields();
				cancelEdit();
				
			} else {
				var msg: String = "The following must be satisfied before saving:\n";
				for (var i: int = 0; i < results.length; i++) {
					msg += results[i].target.source.toolTip + "\n";
				}
				InfoDialog.show(msg);
				
			}
			
			validators = [];
		}
		
		/**
		 * Builds the save vitals widget.
		 * 
		 */
		override protected function buildForm():void
		{		
			if(formContainer == null) {
				
				formContainer = new HBox();
				formContainer.percentWidth = 100;
				formContainer.setStyle("horizontalAlign", "center");
				
				var topSpacer:Spacer = new Spacer();
				topSpacer.percentWidth = 30;
				
				formContainer.addChild(topSpacer);
				
				var topForm:Form = new Form();
				
				var bpFormItem:FormItem = new FormItem();
				bpFormItem.label = "BP";
				
				bpTextInput = new TextInput();
				bpTextInput.text = "0/0";
				bpTextInput.width = 60;
				bpTextInput.toolTip="Enter BP Number/Number.";
				addEventListenerForComponent(bpTextInput);
				
				bpFormItem.addChild(bpTextInput);
				
				topForm.addChild(bpFormItem);
				
				var tfFormItem:FormItem = new FormItem();
				tfFormItem.label = "T(F)";
				
				
				tfNumberStepper= new NumericStepper();
				tfNumberStepper.stepSize = 0.1;
				tfNumberStepper.maximum = 120;
				tfNumberStepper.minimum = 0;
				tfNumberStepper.width = 60;
				//addMouseClickEventListenerForComponent(tfNumberStepper);
				addEventListenerForComponent(tfNumberStepper);			
				addButtonEventListenerForComponent(tfNumberStepper);
				
				
				tfFormItem.addChild(tfNumberStepper);
				
				topForm.addChild(tfFormItem);
				
				var pFormItem:FormItem = new FormItem();
				
				pFormItem.label = "P";
				
				pNumberStepper = new NumericStepper();
				pNumberStepper.stepSize = 1;
				pNumberStepper.maximum = 200;
				pNumberStepper.minimum = 0;
				pNumberStepper.width = 60;
				addEventListenerForComponent(pNumberStepper);
				//addMouseClickEventListenerForComponent(tfNumberStepper);
				addButtonEventListenerForComponent(pNumberStepper);				
				pFormItem.addChild(pNumberStepper);
				
				topForm.addChild(pFormItem);
				
				
				var bottomForm:Form = new Form();
				
				var rrFormItem:FormItem = new FormItem();
				
				rrFormItem.label = "RR";
				
				rrNumberStepper = new NumericStepper();
				rrNumberStepper.stepSize = 1;
				rrNumberStepper.maximum = 200;
				rrNumberStepper.minimum = 0;
				rrNumberStepper.width = 60;
				addEventListenerForComponent(rrNumberStepper);
				//addMouseClickEventListenerForComponent(tfNumberStepper);
				addButtonEventListenerForComponent(rrNumberStepper);
				
				
				rrFormItem.addChild(rrNumberStepper);
				
				bottomForm.addChild(rrFormItem);
				
				var htFormItem:FormItem = new FormItem();
				
				htFormItem.label = "Ht (in)";
				
				htNumberStepper = new NumericStepper();				
				htNumberStepper.stepSize = 1;
				htNumberStepper.maximum = 200;
				htNumberStepper.minimum = 0;
				htNumberStepper.width = 60;
				addEventListenerForComponent(htNumberStepper);
				//addMouseClickEventListenerForComponent(tfNumberStepper);
				addButtonEventListenerForComponent(htNumberStepper);
				
				htFormItem.addChild(htNumberStepper);
				
				bottomForm.addChild(htFormItem);
				
				var wtFormItem:FormItem = new FormItem();
				
				wtFormItem.label = "Wt (lbs)";
				
				wtNumberStepper = new NumericStepper();
				wtNumberStepper.stepSize = 1;
				wtNumberStepper.maximum = 500;
				wtNumberStepper.minimum = 0;
				wtNumberStepper.width = 60;
				addEventListenerForComponent(wtNumberStepper);
				//addMouseClickEventListenerForComponent(tfNumberStepper);
				addButtonEventListenerForComponent(wtNumberStepper);
				
				wtFormItem.addChild(wtNumberStepper);
				
				bottomForm.addChild(wtFormItem);
				
				var painFormItem:FormItem = new FormItem();
				
				painFormItem.label = "Pain Severity";
				
				painNumberStepper = new NumericStepper();
				painNumberStepper.stepSize = 1;
				painNumberStepper.maximum = 10;
				painNumberStepper.minimum = 0;
				painNumberStepper.width = 60;
				addEventListenerForComponent(painNumberStepper);
				//addMouseClickEventListenerForComponent(tfNumberStepper);
				addButtonEventListenerForComponent(painNumberStepper);
				
				painFormItem.addChild(painNumberStepper);
				
				bottomForm.addChild(painFormItem);
							
				
				formContainer.addChild(topForm);
				
				formContainer.addChild(bottomForm);
				
				var bottomSpacer:Spacer = new Spacer();
				bottomSpacer.percentWidth = 30;
				
				formContainer.addChild(bottomSpacer);
				
				
				initValidators();
				
				addChild(formContainer);
				
				configButtons();
				
			}
		}
		
		/**
		 * Sets the save and reset buttons to enable or disable based on dfn entry changes.
		 * 
		 */
		protected override function entryChanged():void			
		{
			super.entryChanged();
			
			if(model.logEdit.entry.dfn == '' || model.logEdit.entry.dfn == null ) {
				if (this.saveButton != null) {
					saveButton.enabled = false;
				}
				if (this.resetButton != null) {
					resetButton.enabled = false;
				}
			} else {
				if (this.saveButton != null && model.vitalsSaved) {
					saveButton.enabled = true;
				}
				if (this.resetButton != null && model.vitalsSaved) {
					resetButton.enabled = true;
				}
			}
			
		}
		
		private function configButtons():void
		{
			if (this.saveButton != null) {
					
				BindingUtils.bindProperty(saveButton, 'enabled', model, "vitalsSaved");

			}
			
			if (this.resetButton != null) {
				
				BindingUtils.bindProperty(resetButton, 'enabled', model, "vitalsSaved");	
				
			}
		}
		
		/**
		 * This will build the GUI components associated with this widget.
		 */
		override protected function build():void
		{			
			super.build();
		}			
		
		/**
		 * Called when the widget has executed its RPC call. 
		 */
		protected override function execute(event : CairngormEvent):void
		{
			executingEvent.dispatch();
			
		}
		/**
		 * Called when the widget has saved its RPC call. 
		 */
		protected override function  saveSuccess(data:Object): void {
			savedEvent.dispatch();
		}
		
		/**
		 * Initializes various events. 
		 */
		protected override function initEvents(event:CairngormEvent):void
		{
			initializingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.INITIALIZING,"VS");
			initializedEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.INITIALIZED,"VS");
			executingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.EXECUTING,"VS");
			editingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.EDITING,"VS");
			savingEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.SAVING,"VS");
			savedEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.SAVED,"VS");
			errorEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.ERROR,"VS");
			resetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.RESET,"VS");
		}
		
		/**
		 * Registers listeners. 
		 */
		protected override function registerListeners():void
		{
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.INITIALIZING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.INITIALIZED,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.EXECUTING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.EDITING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.SAVING,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.SAVED,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.ERROR,handleWidgetStateChange);
			CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.RESET,handleWidgetStateChange);
			BindingUtils.bindSetter(currentEntry,model,getPropertyChainFromValue("logEdit.entry"));
		}
		
		private function handleWidgetStateChange(event:WorkSheetWidgetEvent) :void
		{
			if (event.widgetDataType != "VS") {	// Workaround for this visit widget			
				return;				
			}
			
			trace("event.type " + this.event.type + " event.widgetDataType " + event.widgetDataType);
			
			if (event.type == INITIALIZED) {
				progressBar.setProgress(0, 100);
				progressBar.label = SAVE_MESSAGE;
				progressBar.setStyle("barColor", "gray");
				trace("INITIALIZED event.widgetDataType " + event.widgetDataType);
			} else if (event.type == INITIALIZING) {
				progressBar.setProgress(50, 100);
				progressBar.label = INITIALIZING;
				progressBar.setStyle("barColor", "yellow");			
			} else if (event.type == EXECUTING) {
			 	progressBar.setProgress(35, 100);
				progressBar.label = EXECUTING;
				progressBar.setStyle("barColor", "yellow");			
				savingEvent.dispatch();
			} else if (event.type == RESET)	{
				progressBar.setProgress(0, 100);
				progressBar.label = SAVE_MESSAGE;
				progressBar.setStyle("barColor", "gray");
				trace("RESET event.widgetDataType " + event.widgetDataType + " SAVE_MESSAGE " + SAVE_MESSAGE);
			} else if (event.type == EDITING) {
				progressBar.setProgress(0, 100);
				progressBar.label = "Save vitals before selecting a different patient";
				progressBar.setStyle("barColor", "white");
				trace("EDITING event.widgetDataType " + event.widgetDataType);
			} else if (event.type == SAVED) {
				progressBar.setProgress(100, 100);
				progressBar.label = SAVED;
				progressBar.setStyle("barColor", "green");
				trace("SAVED event.widgetDataType " + event.widgetDataType);
			} else if (event.type == SAVING)	{
				progressBar.setProgress(50, 100);
				progressBar.label = SAVING;
				progressBar.setStyle("barColor", "yellow");
			} else if (event.type == ERROR)	{
				progressBar.setProgress(100, 100);
				progressBar.label = ERROR;
				progressBar.setStyle("barColor", "red");
			}								
		}
		
		private function changeField(event: Event): void
		{
			if (event.currentTarget is NumericStepper) {
				
				var value:Number = NumericStepper(event.currentTarget).value;
				
				if (event.currentTarget == tfNumberStepper) 	{
					
					model.vitalsVO.t = value.toString();
					
				} else if (event.currentTarget == pNumberStepper) {
					
					model.vitalsVO.p = value.toString();
					
				} else if (event.currentTarget == rrNumberStepper) {
					
					model.vitalsVO.r = value.toString();
					
				} else if (event.currentTarget == htNumberStepper) {
					
					model.vitalsVO.ht = value.toString();
					
				} else if (event.currentTarget == wtNumberStepper) {
					
					model.vitalsVO.wt = value.toString();
					
				} else if (event.currentTarget == painNumberStepper) {
					
					model.vitalsVO.pn = value.toString();
					
				}
				//model.vitalsSaved = true;
			}		
			
			if (event.currentTarget == bpTextInput) {
				
				var bp:String = TextInput(event.currentTarget).text;
				model.vitalsVO.bp = bp;
				//model.vitalsSaved = true;
			}
			
			if(model.logEdit.entry.dfn != '' && model.logEdit.entry.dfn !=null) {
				model.vitalsSaved = true;
			}
			
			this.editingEvent.dispatch();
		}
		
		/**
		 * Clears several input fields. 
		 */
		public function clearFields() : void
		{			
			bpTextInput.text = "0/0";
			//bpTextInput.validateNow();
			tfNumberStepper.value = 0;
			//tfNumberStepper.validateNow();
			pNumberStepper.value = 0;
			//pNumberStepper.validateNow();
			rrNumberStepper.value = 0;
			//rrNumberStepper.validateNow();
			htNumberStepper.value = 0;
			//htNumberStepper.validateNow()
			wtNumberStepper.value = 0;
			//wtNumberStepper.validateNow();
			painNumberStepper.value = 0;
			//painNumberStepper.validateNow();
			progressBar.label = "";
		}
		
		private function addEventListenerForComponent(uiComponent:UIComponent):void {
			if(!isLightWeight) {
				if(uiComponent != null) {
					uiComponent.addEventListener(Event.CHANGE, componentChanged);	
				}				
			}
		}
		
		private function addButtonEventListenerForComponent(uiComponent:UIComponent):void {
			if(!isLightWeight) {
				if(uiComponent != null) {
					uiComponent.addEventListener(KeyboardEvent.KEY_UP,componentKeyChanged);
					//uiComponent.addEventListener(KeyboardEvent.KEY_DOWN,componentKeyChanged);
				}				
			}
		}
		
		private function addMouseClickEventListenerForComponent(uiComponent:UIComponent):void {
			if(!isLightWeight) {
				if(uiComponent != null) {
					uiComponent.addEventListener(MouseEvent.MOUSE_DOWN,componentMouseClick);
				}				
			}
		}
		
		private function componentChanged(event:Event):void
		{			
			changeField(event);			
		}
		
		private function componentKeyChanged(event:Event):void
		{			
			changeField(event);			
		}
		
		private function componentMouseClick(event:Event):void
		{					
			saveButton.enabled = true;
		}
	}	
}