package gov.va.med.edp.view.worksheet
{
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.utils.StringUtil;
	import mx.validators.ValidationResult;
	import mx.validators.Validator;
	
	/**
	 * 
	 * This validator ensures that the time in can not be after the time out. 
	 * @author iainapostolos
	 * 
	 */
	public class TimeInTimeOutValidator extends Validator
	{
		
		private var results:Array;
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		
		
		/**
		 * Constructor for the TimeInTimeOutValidator.
		 */
		public function TimeInTimeOutValidator()
		{
			super();
			
		}	
		
		/**
		 * Performs validation of the object data.
		 * 
		 * @param value  the object to be validated.
		 * @return Array  the validated results.
		 * 
		 */
		override protected function doValidation(value:Object):Array {
			
			var timeInDate:Date = new Date();
			
			var timeOutDate:Date = new Date();
			
			timeInDate = model.logEdit.entry.inTS;
			
			if(value == null) {
				timeOutDate = model.logEdit.entry.outTS; // This occurs when widget is never touched first.
			} else {
				timeOutDate = (value as Date);
			}
			
			
			
			results = [];
			results = super.doValidation(timeOutDate);
			
			if (results.length > 0)
				return results;
			
			if (timeInDate > timeOutDate) {
				results.push(new ValidationResult(true, null, "timeInGTtimeOut", "Time in date cannot be later than time out date."));
				return results;
			} 					
					
			return results;
		}	
	}
}