package gov.va.med.edp.view.worksheet
{
	import gov.va.med.edp.control.DetailsEvent;
	import gov.va.med.edp.control.GetVitalsEvent;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.model.LogEdit;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.ActiveMedVO;
	import gov.va.med.edp.vo.ActiveProblemsVO;
	import gov.va.med.edp.vo.LogEntryVO;
	import gov.va.med.edp.vo.LookupStringVO;
	import gov.va.med.edp.vo.VitalsVO;
	import gov.va.med.edp.vo.reports.LabTrendVO;
	
	import mx.binding.utils.BindingUtils;
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.controls.Label;
	
	/**
	 * This class creates a label that pull the textual representation of a LookupStringVO data property given a collection to look through.
	 *  
	 * @author useruseruser12
	 * 
	 */
	public class SummaryDataWidgetLabel extends Label
	{
		//private var propertyValue: int;
		private var evaulatedText: String;
		private var dataArray:ArrayCollection;
		private var dataArrayLength:int = 0;
		private var entry: LogEntryVO;
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		private var dataProviderLoaded:Boolean = false;
		private var widgetType:String;
		
		/**
		 * Constructor.
		 * @param propDataProvider - Dataprovider to parse in order to get the string representation of the data.
		 * @param type - The type of widget.
		 */
		public function SummaryDataWidgetLabel(type:String)										 
		{
			super();
						
			if(type != null) {	
				
				trace("SummaryDataWidgetLabel " + type);
				
				widgetType = type;
				
				/*var chain:String = getPropertyChain(widgetType);
				
				if(chain.length > 0) {
					
					trace("Use Chain " + model.getPropertyChainFromValue(chain));
					
					BindingUtils.bindSetter(dataProviderArray,model,getPropertyChainFromValue(chain));
					
				} else {
					
					trace("Not Chain " + getCollectionFromType(widgetType));
					
					BindingUtils.bindSetter(dataProviderArray,model,getCollectionFromType(widgetType));	
				}*/
				
				BindingUtils.bindSetter(dataProviderArray,model,getPropertyChainFromType(widgetType)); 
				
			} else {
				throw new Error("Attempted to instantiate a SummaryDataWidgetLabel with a null property data provider.");
			}			
		}
	
		/**
		 * Utility method for generating a property chain for Binding. 
		 * @param val - The dot delimeted string to break into a chain.
		 * @return The Array of property chain.
		 * 
		 */
		private function getPropertyChainFromType(type:String):Array
		{		
			
			var propertyChain:Array = new Array();			
			//var delimiter:String = ".";			
			
			//trace("getPropertyChainFromType " + type);

			
			if (type == DetailsEvent.EVENT_DETAILS_MEDS) {
				
				propertyChain.push("activeMeds");
				propertyChain.push("length");
				
			} else if (type == DetailsEvent.EVENT_DETAILS_PLIST) {
				
				propertyChain.push("activeProblems");
				propertyChain.push("length");
				
			} else if (type == LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS) {
				
				propertyChain.push("labVOList");
				propertyChain.push("length");
				
			} else if (type == GetVitalsEvent.EVENT_GET_VITALS) {
			
				propertyChain.push("vitalsModel");
				propertyChain.push("vitals");
				propertyChain.push("length");
			
			}
			
			trace("getPropertyChainFromType " + type + " propertyChain " + propertyChain);
			
			return propertyChain;			
		}
		
		private function dataProviderArray(lengthUpdate:int):void
		{		
			trace("Change Occured");
			
			if(dataArrayLength != lengthUpdate) {
				trace("Change Occured size "  + lengthUpdate + " type " + this.widgetType)
				dataArrayLength = lengthUpdate; // Dont iterate if value has not changed.
				evaluateValues();
			}
			
		}
		
		private function evaluateValues(): void
		{
			//trace("Update Values")
			var compiledData:String = getSummaryValueText(widgetType);
			
			this.text = compiledData;
			
		}
		
		private function getPropertyChain(type:String):String
		{
			var propChain:String = "";
			
			if (type == GetVitalsEvent.EVENT_GET_VITALS) {
				
				propChain = "vitalsModel.vitals";
				
			} 
			
			return propChain;
		}
		
		private function getCollectionFromType(type:String) : String
		{
			var propertyNameOfArray:String;
			
			if (type == DetailsEvent.EVENT_DETAILS_MEDS) {
				
				propertyNameOfArray = "activeMeds";		
				
			} else if (type == DetailsEvent.EVENT_DETAILS_PLIST) {
				
				propertyNameOfArray = "activeProblems";								
			
			} else if (type == LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS) {
				
				propertyNameOfArray = "labVOList";		
				
			} /*else if (type == GetVitalsEvent.EVENT_GET_VITALS) {
				
				propertyNameOfArray = "vitalsModel.vitals";		// FIX	
				
			}*/
						
			return  propertyNameOfArray;			
			
		}
		
		/**
		 * Get the text determined by the event type.
		 * 
		 * @param type - The type of widget.
		 * @return The text associated with the collection for this widget.
		 * 
		 */
		public function getSummaryValueText(type:String): String
		{
			
			var summaryValueText:String = new String();
			
			if (type == DetailsEvent.EVENT_DETAILS_MEDS) {
				
				var activeMed:ActiveMedVO;
				
				if(model.activeMeds != null && model.activeMeds.length > 0) {
					
					activeMed =  (model.activeMeds.getItemAt(0) as ActiveMedVO);
					
				} else {
					
					activeMed = new ActiveMedVO();
					activeMed.name = "No data";
					activeMed.sig = "No data";
					activeMed.status = "No data";	
					
				}
				
				summaryValueText = "Name : " + activeMed.name + ", Sig : " + activeMed.sig + ", Status : " + activeMed.status;			
				
				
			} else if (type == DetailsEvent.EVENT_DETAILS_PLIST) {
				
				var activeProblem:ActiveProblemsVO;
				
				if(model.activeProblems != null && model.activeProblems.length > 0) {
					
					activeProblem =  (model.activeProblems.getItemAt(0) as ActiveProblemsVO);
					
				} else {
					
					activeProblem = new ActiveProblemsVO();
					activeProblem.name = "No data";
					activeProblem.icd = "No data";
					
				}
				
				summaryValueText = "Name : " + activeProblem.name + ", ICD : " + activeProblem.icd;
				
				
			} else if (type == LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS) {
				
				var labTrend:LabTrendVO;				
				
				if(model.labVOList != null && model.labVOList.length > 0) {
					
					labTrend =  (model.labVOList.getItemAt(0) as LabTrendVO);
					
				} else {
					
					labTrend = new LabTrendVO();
					labTrend.collectedTS = "No data";
					labTrend.deviation = "No data";
					labTrend.high = "No data";
					labTrend.low = "No data";
					labTrend.result = "No data";
					labTrend.resultedTS = "No data";
					labTrend.testName = "No data";
					labTrend.units = "No data";
					
				}
				
				summaryValueText = "Name : " + labTrend.testName 
					+ ", Result : " + labTrend.result 
					+ ", Units : " + labTrend.units
					+ ", High : " + labTrend.high
					+ ", Low : " + labTrend.low
					+ ", Collected : " + labTrend.collectedTS
					+ ", Resulted : " + labTrend.resultedTS;
				
				
				
				
			} else if (type == GetVitalsEvent.EVENT_GET_VITALS) {
				
				var vitalsVO: VitalsVO;
				
				if(model.vitalsModel.vitals != null && model.vitalsModel.vitals.length > 0) {
					
					vitalsVO =  (model.vitalsModel.vitals.getItemAt(0) as VitalsVO);
					
				} else {
					
					vitalsVO = new VitalsVO();
					vitalsVO.bp = "No data";
					vitalsVO.ht = "No data";
					vitalsVO.p = "No data";
					vitalsVO.pn = "No data";
					vitalsVO.r = "No data";
					vitalsVO.t = "No data";
					vitalsVO.time = "No data";
					vitalsVO.wt = "No data";					
					
				}
				
				summaryValueText = "Time : " + vitalsVO.time 
					+ ", Temp(f) : " + vitalsVO.t 
					+ ", Pulse : " + vitalsVO.p
					+ ", Resp : " + vitalsVO.r
					+ ", B/P : " + vitalsVO.bp
					+ ", Wt(lbs) : " + vitalsVO.wt
					+ ", Pain : " + vitalsVO.pn;
				
				
			}
			
			return summaryValueText;
		}		
	}
}