package gov.va.med.edp.view.worksheet
{
	import gov.va.med.edp.model.LogEdit;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.LogEntryVO;
	import gov.va.med.edp.vo.LookupStringVO;
	
	import mx.binding.utils.BindingUtils;
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.controls.Label;
	
	/**
	 * This class creates a label that pull the textual representation of a LookupStringVO data property given a collection to look through.
	 *  
	 * @author useruseruser12
	 * 
	 */
	public class SummaryDataLabel extends Label
	{

		private var propertyValue: int;
		private var evaulatedText: String;
		private var dataArray:ArrayCollection;
		private var entry: LogEntryVO;
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		private var dataProviderLoaded:Boolean = false;		
		
		/**
		 * Constructor.
		 * @param propVal - Value to associate this label with.
		 * @param propDataProvider - Dataprovider to parse in order to get the string representation of the data.
		 * 
		 */
		public function SummaryDataLabel(propVal:String,
										 propDataProvider:String)										 
		{
			super();
			
			if(propVal != null) {
				
				BindingUtils.bindSetter(dataValue,model,model.getPropertyChainFromValue(propVal));
				
			} else {
				throw new Error("Attempted to instantiate a SummaryDataLabel with a null property value.");
			}
			
			if(propDataProvider != null) {
						
				BindingUtils.bindSetter(dataProviderArray,model,model.getPropertyChainFromValue(propDataProvider));
				
			} else {
				throw new Error("Attempted to instantiate a SummaryDataLabel with a null property data provider.");
			}			
		}
				
		private function dataProviderArray(provider:ArrayCollection):void
		{
			dataArray = provider;
		}
		
		private function dataValue(dataVal:int):void
		{
			if(dataVal != propertyValue) {
				propertyValue = dataVal; // Dont iterate if value has not changed.
				evaluate(propertyValue);
			}
		}
		
		private function evaluate(data: int): void
		{
			for each (var lookupStringVO:LookupStringVO in dataArray) {
				var currentData:int = parseInt(lookupStringVO.data);
				if (data == currentData) {
					evaulatedText = lookupStringVO.label;
					this.text = evaulatedText;
					break;
				}
			}
		}
	}
}