package gov.va.med.edp.view.worksheet
{
	import com.adobe.cairngorm.control.CairngormEventDispatcher;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import gov.va.med.edp.control.ChangeLogEntryFieldEvent;
	import gov.va.med.edp.control.SwitchLogEntryEvent;
	import gov.va.med.edp.cpe.view.log.DiagnosesCoded;
	import gov.va.med.edp.cpe.view.log.DiagnosesFreeText;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.model.worksheet.SectionModel;
	import gov.va.med.edp.pt.demog.model.PatientSelectVO;
	import gov.va.med.edp.util.ChangeWatcher;
	import gov.va.med.edp.vo.LookupStringVO;
	import gov.va.med.edp.vo.worksheet.ComponentVO;
	import gov.va.med.edp.widget.DateTimeChooser;
	
	import mx.binding.utils.BindingUtils;
	import mx.collections.ArrayCollection;
	import mx.containers.Canvas;
	import mx.containers.HBox;
	import mx.containers.VBox;
	import mx.controls.Alert;
	import mx.controls.Button;
	import mx.controls.Label;
	import mx.core.UIComponent;
	import mx.utils.ObjectUtil;
	import mx.validators.Validator;
	
	/**
	 * 
	 * Creates sections for different worksheet widgets
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class SectionPanel extends VBox
	{
		
		[Bindable]
		/**
		 * The heading.
		 * 
		 */
		public var heading: String = "Missing Heading";
		[Bindable]
		/**
		 * The header value.
		 * 
		 */
		public var header: String = "";
		
		[Embed(source="Assets.swf", symbol="TreeDisclosureClosed")]
		[Bindable]
		private var DIS_CLOSED:Class;
		
		[Embed(source="Assets.swf", symbol="TreeDisclosureOpen")]
		[Bindable]
		private var DIS_OPEN:Class;
		
		[Bindable]
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		
		/**
		 * The edit area UI component.
		 * 
		 */
		public var editArea: UIComponent;		
		private var shouldExpandOnCreation: Boolean = false;		
		private var btnSummarize:Button;		
		private var summaryCanvas:Canvas;				
		private var lblHeader:Label;
		private var hboxHeader:HBox;
		/*
		 * Section related artifacts.
		 */
		[Bindable]
		private var sectionModel:SectionModel;
		
		private var isLightWeight:Boolean = false;
		
		private var workSheetPanel:WorkSheetPanel;

		/**
		 * This panel contains the componenents for a 
		 * particular section.
		 * 
		 * @param parent The WorkSheetPanel which this SectionPanel resides.
		 * @param model The model associated with this panel.
		 * @param lightWeight - True if this is used for preview purposes.
		 * 
		 */
		public function SectionPanel(parent:WorkSheetPanel,
									 model:SectionModel,
									 lightWeight:Boolean = false)
		{
			super();
			workSheetPanel = parent;
			sectionModel = model;
			isLightWeight = lightWeight;			
			init();
			
			
		}
		
		private function init() : void 
		{
			this.percentWidth = 100;
			this.styleName = "worksheetSectionPanel";
			
			if(!isLightWeight) {
				registerListeners();	
			}
			
			createFormItemsFromComponents();
			
			createSummaryCanvas();
			
			var initiallyExpanded:Boolean = 
				stringToBoolean(sectionModel.getSectionVO().initiallyExpanded);
			
			if(initiallyExpanded)
			{	
				toggleBoard(true);	
			}

		}
		
		private function registerListeners():void
		{
			CairngormEventDispatcher.getInstance().addEventListener(
				ChangeLogEntryFieldEvent.EVENT_CHANGE_LOG_ENTRY_FIELD, handleLogEntryFieldChange);
			CairngormEventDispatcher.getInstance().addEventListener(
				SwitchLogEntryEvent.EVENT_SWITCH_LOG_ENTRY, handleSwitchLogEntryChange);
		}
		
		private function handleSwitchLogEntryChange(switchEvent:SwitchLogEntryEvent) :void
		{
			//buildSummary(); // This sends in all events of this type so you get one for each section, ugh TODO filter
		}
		
		private function handleLogEntryFieldChange(changeEvent:ChangeLogEntryFieldEvent) :void
		{
			
			//buildSummary();
			
			switch(changeEvent.field)
			{
				case "patient":
					// set the name, ssn, and dfn all at once
					var patientVO: PatientSelectVO = changeEvent.value as PatientSelectVO;
					/*if ((model.logEdit.entry != null && model.logEdit.entry.name == "(ambulance)") && 
						(patientVO.name != "(ambulance)") &&
						(model.logEdit.entry.inTS == null) ) {
						model.logEdit.entry.inTS = model.buildSiteDate();
						model.logEdit.patientSelected = true;	
					}
					model.logEdit.entry.name = patientVO.name;
					model.logEdit.entry.ssn = patientVO.ssn;
					model.logEdit.entry.dob = patientVO.dob;
					model.logEdit.entry.dfn = patientVO.dfn;
					synchSelector("name", patientVO.name);
					synchSelector("ssn", patientVO.ssn);
					*/
					break;
				case "name":
					//model.logEdit.entry.name = changeEvent.value;
					//synchSelector(changeEvent.field, changeEvent.label);
					break;
				case "ssn":
					//model.logEdit.entry.ssn = changeEvent.value;
					//synchSelector(changeEvent.field, changeEvent.label);
					break;
				case "inTS":
					//model.logEdit.entry.inTS = changeEvent.value;
					//model.logEdit.entry.requireDelay = isDelayRequired();
					break;
				case "outTS":
					//model.logEdit.entry.outTS = changeEvent.value;
					//model.logEdit.entry.requireDelay = isDelayRequired();
					break;
				case "complaint":
					model.logEdit.entry.complaint = changeEvent.value;
					break;
				case "longComplaint":
					//model.logEdit.entry.longComplaint = changeEvent.value;
					break;
				case "arrival":
					//model.logEdit.entry.arrival = changeEvent.value;
					break;
				case "bed":
					//model.logEdit.entry.bed = changeEvent.value;
					//if (int(changeEvent.reference) > 0) {
					//	model.logEdit.entry.status = int(changeEvent.reference);
					//} else {
					//	if (model.logEdit.undo != null) {
					//		model.logEdit.entry.status = model.logEdit.undo.status;
					//	}
					//}
					break;
				case "acuity":
					//model.logEdit.entry.acuity = changeEvent.value;
					break;
				case "clinic":
					//model.logEdit.entry.clinic = changeEvent.value;
					break;
				case "status":
					//model.logEdit.entry.status = changeEvent.value;
					break;
				case "provider":
					//model.logEdit.entry.provider = changeEvent.value;
					break;
				case "resident":
					//model.logEdit.entry.resident = changeEvent.value;
					break;
				case "nurse":
					//model.logEdit.entry.nurse = changeEvent.value;
					break;
				case "comment":
					//model.logEdit.entry.comment = changeEvent.value;
					break;
				case "disposition":
					//model.logEdit.entry.disposition = changeEvent.value;
					//model.entryRemoveReady();
					break;
				case "delay":
					//model.logEdit.entry.delay = changeEvent.value;
					//model.entryRemoveReady();
					break;
				case "diagnoses":
					//var pceItem: PCECodedValueVO = changeEvent.value as PCECodedValueVO;
					//if (changeEvent.clear) {
						// clear means we want to remove the item
					//	var index: int = model.logEdit.entry.diagnoses.getItemIndex(pceItem);
					//	if (pceItem.added) {
							// remove from list if we just added it in this session
					//		model.logEdit.entry.diagnoses.removeItemAt(index);
					//	} else {
							// otherwise set remove to true so PCE can remove it
					//		model.logEdit.entry.diagnoses[index].remove = true;
					//	}
					//} else if (pceItem.updated){ // MAKE SURE THAT UPDATE IS CHECKED BEFORE ADD..
					//	pceItem.updated = true	// BECAUSE AN ITEM CAN BE ADDED AND THEN UPDTED IN THE SAME SESSION
					//	model.logEdit.entry.diagnoses[index].updated = true;
					//} else if (pceItem.added){
					//	pceItem.added = true;
					//	model.logEdit.entry.diagnoses.addItem(pceItem);
					//} 
					//model.logEdit.entry.updatedDiagnoses = true;
					//model.entryRemoveReady();
					break;
			} // switch
		}
		
		private function createSummaryCanvas():void
		{
			if (summaryCanvas == null) {
			
				summaryCanvas = new Canvas();
				summaryCanvas.percentWidth = 100;
				summaryCanvas.horizontalScrollPolicy = "off";
			
				btnSummarize = new Button();
				btnSummarize.toggle = true;
				btnSummarize.width = 22;
				btnSummarize.setStyle("icon", DIS_CLOSED);
				btnSummarize.setStyle("left",0);
				btnSummarize.setStyle("top",0);
				btnSummarize.addEventListener(MouseEvent.CLICK, btnclickHandler);
				
				summaryCanvas.addChild(btnSummarize);
						
				lblHeader = new Label();
				lblHeader.setStyle("fontWeight","bold");
				lblHeader.setStyle("fontSize","11");
				lblHeader.setStyle("left",26);
				lblHeader.setStyle("top",2);
				
				BindingUtils.bindProperty(lblHeader, 'text', this, "heading");
				
				heading = sectionModel.getSectionVO().name;
				
				summaryCanvas.addChild(lblHeader);
										
				//addChild(summaryCanvas);
				
				hboxHeader = createSummary();								
				hboxHeader.setStyle("left",180);
				hboxHeader.setStyle("top",2);
				summaryCanvas.addChild(hboxHeader);
				addChild(summaryCanvas);					
			}
						
		}
		
		private function btnclickHandler(event:MouseEvent):void {
			var b: Button = event.currentTarget as Button;		
			toggleBoard(b.selected);
		}
		
		/**
		 * Expands on creation based on the indicator.
		 * 
		 * @param expand  the indicator to show expand on creation
		 * 
		 */
		public function setShouldExpandOnCreation(expand: Boolean) : void
		{
			shouldExpandOnCreation = expand;	
		}
		
		/**
		 * Toggle edit area based on the button selection
		 * 
		 * @param expand  the indicator for toggle action
		 * 
		 */
		public function toggleBoard(expand: Boolean) : void
		{
			if(expand) {
				
				btnSummarize.selected = true;
				btnSummarize.setStyle("icon", DIS_OPEN);
				setStyle("backgroundColor", 0xD8D8D8);
				hboxHeader.visible = false;
				addChild(editArea);
				
			} else {
				
				btnSummarize.selected = false;
				btnSummarize.setStyle("icon", DIS_CLOSED);
				setStyle("backgroundColor", 0xDDDDDD);
				hboxHeader.visible = true;
				removeChild(editArea);	
				
			}
		}
	
		private function createFormItemsFromComponents():void
		{								
			var form:WorkSheetForm = new WorkSheetForm();
			
			var components:Array;			
			var i:int = 0;
			var length:int = 0;			
			var componentFormItem:WorkSheetFormItem;
			var componentVO:ComponentVO;
			
			components = sectionModel.getComponentArray();
			
			length = components.length;
			
			for (i; i < length; i++)
			{				
				componentVO = components[i] as ComponentVO;	
				componentFormItem = new WorkSheetFormItem();				
				componentFormItem.addChild(createComponent(componentVO,componentFormItem));			
				form.addChild(componentFormItem);
			}
			
			this.editArea = form;
		}
		
		private function createLightWeightFormItemsFromComponents():void
		{								
			
			var form:WorkSheetForm = new WorkSheetForm();
			
			var components:Array;			
			var i:int = 0;
			var length:int = 0;			
			var componentFormItem:WorkSheetFormItem;
			var componentVO:ComponentVO;
			
			components = sectionModel.getComponentArray();
			
			length = components.length;
			
			for (i; i < length; i++)
			{				
				componentVO = components[i] as ComponentVO;				
				componentFormItem = new WorkSheetFormItem();				
				componentFormItem.addChild(createComponent(componentVO,componentFormItem));			
				form.addChild(componentFormItem);
			}
			
			this.editArea = form;
		}
		
		/**
		 * Creates the summary widget.
		 * 
		 * @return HBox  the summary data widget.
		 */
		public function createSummary():HBox
		{
			var hbox:HBox = new HBox();
			hbox.setStyle("backgroundColor","white");
			hbox.setStyle("borderStyle","solid");
			hbox.setStyle("borderThickness","1");
			hbox.setStyle("cornerRadius","3");
			
			var summary:String;
			var components:Array;			
			var componentVO:ComponentVO;
			var length:int = 0;
			var i:int = 0;
			var sortedComponentsInSummary:ArrayCollection = new ArrayCollection();
			var componentsInSummary:ArrayCollection = new ArrayCollection();			
						
			components = sectionModel.getComponentArray()				
			length = components.length;
			
			for (i; i < length; i++) 
			{
				componentVO = components[i] as ComponentVO;
				
				var includeInSummary:Boolean = 
					stringToBoolean(componentVO.includeInSummary);
				
				if(includeInSummary)
				{
					
					var lblCompSumLabel:Label = new Label();
					lblCompSumLabel.setStyle("fontWeight","bold");
					lblCompSumLabel.setStyle("fontSize","10");
					
					var lblCompValue:Label;
					
					if(componentVO.component is WorkSheetValueComboBox) {
					
						lblCompValue = new SummaryDataLabel(componentVO.value,
							componentVO.dataProvider);
						
					
					} else if (componentVO.component is LoadWorkSheetWidget) {
						
						lblCompValue = new SummaryDataWidgetLabel(componentVO.loadEvent.type);
						
					} else if (componentVO.component is VitalsSaveWidget) {
						
						lblCompValue = new Label();
						lblCompValue.text = "Expand to enter data";
						
					} else {
					
						lblCompValue = new Label();
						bindProperty(lblCompValue, 'text', model, getPropertyChainFromValue(componentVO.value));
					
					} 
					

					lblCompValue.setStyle("fontSize","10");
					lblCompValue.setStyle("fontStyle","italic");
					
					lblCompSumLabel.text = componentVO.summaryLabel + " : ";
					
					shouldDisplaySummaryLabel(componentVO.visibilityTrigger,lblCompSumLabel,true);
					shouldDisplaySummaryLabel(componentVO.visibilityTrigger,lblCompValue,true);

					hbox.addChild(lblCompSumLabel);
					hbox.addChild(lblCompValue);
				}			
			}
			
			return hbox;
		}
		
		private function copyArrayCollection(chain:Array):ArrayCollection
		{
			var copy:ArrayCollection = new ArrayCollection();
			
			BindingUtils.bindSetter(arrayChanged,model, chain);
			
			//BindingUtils.bindProperty(this, copy.source, model, chain);
			
			return copy;
		}
		
		/**
		 * This is for changes in array.
		 * 
		 */
		protected function arrayChanged(label: ArrayCollection): void
		{
			//f  (label == null) return;
			
		}
		/**
		 * This is for changes in label.
		 * 
		 */		
		protected function labelChanged(label: String): void
		{
			if (label == null) return;
					
		}
				
		private function bindProperty(
			site:Object, prop:String,
			host:Object, chain:Object,
			propOverride:Boolean = false):void
		{
			//Alert.show("SectionPanel.bindProperty " +
			//	"site = " + site + " , prop = " + prop + " , host = " + host + " , chain = " + chain);
			if(propOverride || !isLightWeight) {
				BindingUtils.bindProperty(site, prop, host, chain);	
			}
		}
		
		private function addEventListenerForComponent(uiComponent:UIComponent):void {
			if(!isLightWeight) {
				if(uiComponent != null) {
					uiComponent.addEventListener(Event.CHANGE, componentChanged);	
				}				
			}
		}
		
		private function createComponent(componentVo:ComponentVO,
										 componentFormItem:WorkSheetFormItem): UIComponent
		{
					
			if (componentVo.component.id == "source") {
				componentVo.component.id = "arrival";
			}
			var uiComponent:UIComponent = componentVo.component;
			var shouldOverride:Boolean = false;
			
			
			//Alert.show("SectionPanel.createComponent " +
			//	"componentVo.value -> " + componentVo.value + " componentVo.name : " + componentVo.name 
			//	+ " componentVo.dataProvider : " + componentVo.dataProvider 
			//	+ " : model.logEdit.entry -> " + model.logEdit.entry.toString());
			
			
			if (componentVo.editable == "false" && !(uiComponent is LoadWorkSheetWidget))
			{
				var uiComponentLabel:Label;
				componentFormItem.label = componentVo.label;
				
				if(uiComponent is WorkSheetValueComboBox) {
					
					uiComponentLabel = new SummaryDataLabel(componentVo.value,
						componentVo.dataProvider);
					
				} else {
					
					uiComponentLabel = new Label();
					bindProperty(uiComponentLabel, 'text', model, getPropertyChainFromValue(componentVo.value));
				
				}
				
				uiComponentLabel.styleName="formField";
				
				return uiComponentLabel; 
			}
			
			
			if (uiComponent is WorkSheetTextInput) 
			{			
				componentFormItem.label = componentVo.label;							
				bindProperty((uiComponent as WorkSheetTextInput), 'text', model, getPropertyChainFromValue(componentVo.value));							
				addEventListenerForComponent((uiComponent as WorkSheetTextInput));
				
			} else if (uiComponent is WorkSheetValueComboBox)   {
				/*if(componentVo.dataProvider == "logEdit.arrivals") {
				
				Alert.show("WorkSheetValueComboBox  " + model.logEdit.arrivals);
				var i:int = 0;
				for (i; i < model.logEdit.arrivals.length; i++) {
					Alert.show("VAL  " + (model.logEdit.arrivals[i] as LookupStringVO).label);
				}
				
				}
				*/

				componentFormItem.label = componentVo.label;
				bindProperty((uiComponent as WorkSheetValueComboBox), 'value', model, getPropertyChainFromValue(componentVo.value));
				bindProperty((uiComponent as WorkSheetValueComboBox), 'dataProvider', model, getPropertyChainFromValue(componentVo.dataProvider));
				addEventListenerForComponent((uiComponent as WorkSheetValueComboBox));
				
			} else if (uiComponent is DateTimeChooser) {
				
				componentFormItem.label = componentVo.label;
				(uiComponent as DateTimeChooser).initialize(); // Workaround for the inner components causing null pointer exceptions.
				(uiComponent as DateTimeChooser).tabEnabled = true;
				(uiComponent as DateTimeChooser).dateType = componentVo.label;
				bindProperty((uiComponent as DateTimeChooser), 'selectedDate', model, getPropertyChainFromValue(componentVo.value));
				addEventListenerForComponent((uiComponent as DateTimeChooser));
				//<widget:DateTimeChooser
				//id="inTS"
				//tabEnabled="true" 
				//dateType="Time In"
				//selectedDate="{model.logEdit.entry.inTS}"  
				//change="performDateValidation();changeField(event);"
				//styleName="formField" tabIndexBase="1112" />
				//} else if (uiComponent is WorkSheetDataGridWidget) {
			} else if (uiComponent is LoadWorkSheetWidget) {
				
				//componentFormItem.setStyle("labelWidth", 1);
				componentFormItem.styleName="worksheetWidgetFormItem";
				componentFormItem.setStyle("indicatorGap", 0);			 
				//(uiComponent as LoadWorkSheetWidget).event = componentVo.loadEvent; // Fix the order of things.
				//BindingUtils.bindProperty((uiComponent as LoadWorkSheetWidget), 'dataProvider', model, getPropertyChainFromValue(componentVo.dataProvider));
				(uiComponent as LoadWorkSheetWidget).init(componentVo.loadEvent,componentVo.label,isLightWeight);			
				
			} else if (uiComponent is VitalsSaveWidget) {

				componentFormItem.styleName="worksheetWidgetFormItem";
				componentFormItem.setStyle("indicatorGap", 0);					
				(uiComponent as VitalsSaveWidget).initWidget(componentVo.label,isLightWeight);	
				
			} else if ((uiComponent is DiagnosesCoded) || (uiComponent is DiagnosesFreeText)) {
				componentFormItem.label = componentVo.label; // Probably want to hide this
				shouldOverride = true; // Want to show this in preview
			}
			
			/*
			* Only show component if applicable.
			*/
			shouldDisplayComponent(componentVo.visibilityTrigger,
				componentFormItem,shouldOverride);
			
			addValidator(componentVo.validator);
			
			//createSummary(componentVo);
			
			return uiComponent;
		}
				
		private function shouldDisplayComponent(visibilityTrigger:String,
												componentFormItem:WorkSheetFormItem,
												shouldOverride:Boolean = false):void
		{
			//Alert.show("SectionPanel.shouldDisplayComponent " +
			//	"visibilityTrigger -> " + visibilityTrigger + " shouldOverride : " + shouldOverride);
			
			if (shouldOverride || !isLightWeight) {
			
				var visTriggerPropertyChain:Array;
			
				if (visibilityTrigger != null && visibilityTrigger.length > 0) 
				{											
					visTriggerPropertyChain =  getPropertyChainFromValue(visibilityTrigger,shouldOverride);
					
					//Alert.show("SectionPanel.shouldDisplayComponent " +
					//	"visTriggerPropertyChain -> " + visTriggerPropertyChain);
					
					bindProperty(componentFormItem, 'includeInLayout', model, visTriggerPropertyChain,shouldOverride); 				
					bindProperty(componentFormItem, 'visible', model, visTriggerPropertyChain,shouldOverride); 
				
				}
			}			
		}
		
		
		private function shouldDisplaySummaryLabel(visibilityTrigger:String,
												label:Label,
												override:Boolean = false):void
		{
			var visTriggerPropertyChain:Array;
			
			if (visibilityTrigger != null && visibilityTrigger.length > 0) 
			{											
				visTriggerPropertyChain =  getPropertyChainFromValue(visibilityTrigger,override);
				
				if (override) {
					BindingUtils.bindProperty(label, 'includeInLayout', model, visTriggerPropertyChain);
					BindingUtils.bindProperty(label, 'visible', model, visTriggerPropertyChain);	
				} else {
					bindProperty(label, 'includeInLayout', model, visTriggerPropertyChain);
					bindProperty(label, 'visible', model, visTriggerPropertyChain); 
				}
																
			}			
		}
		
		private function getPropertyChainFromValue(val:String,
												   shouldOverride:Boolean = false):Array
		{		
						
			var propertyChain:Array = new Array();			
			
			if (shouldOverride || !isLightWeight) {
				var delimiter:String = ".";			
				
				if (val != null && val.length > 0) 
				{							
					propertyChain = val.split(delimiter);		 				
				}	
			}
			
			return propertyChain;			
		}
		
		private function componentChanged(event:Event):void
		{			
			ChangeWatcher.changeField(event);			
		}
		
		private function stringToBoolean(value:String):Boolean
		{
			var convert:Boolean = Boolean(false);
			
			if(value != null){
				if (value == "true") {
					convert = true;	
				} 
			}		
			return convert;
		}
		
		/**
		 * Adds the validator from the validators list.
		 * 
		 * @param validator - The validator to add.
		 * 
		 */
		private function addValidator(validator:Validator):void
		{
			if(validator != null) {			
				if(workSheetPanel != null) {
					workSheetPanel.addValidator(validator);	
				}				
			}
		}
	}
		
}