package gov.va.med.edp.view.worksheet
{
	import mx.controls.Button;
	import mx.containers.HBox;
	import mx.controls.Label;
	import mx.validators.Validator;
	import flash.events.MouseEvent;
	/**
	 * Creates the worksheet with save and reset buttons 
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class SaveWorksheetWidget extends WorkSheetWidget
	{
		private var lblTitle:Label;
		private var controlBar:HBox;
		private var controlBarHeader:HBox;
		protected var saveButton:Button;
		protected var resetButton:Button;
		[Embed(source="/assets/save16x16.png")]
		private var saveIconClass: Class;
	
		
		/**
		 * Constructor
		 * 
		 */
		public function SaveWorksheetWidget()
		{
			super();
			this.styleName = "worksheetSaveWidget";
		}
		
		/**
		 * This is to be overridden by sub classes
		 */
		protected function save():void
		{
			
		}
		
		/**
		 * Calls create control bar to create save and reset.
		 */
		override protected function createNorthPanel():void
		{
			createControlBar();
		}
		
		private function createControlBarHeader():HBox
		{			
			if (controlBarHeader == null) 
			{							
				controlBarHeader = WorkSheetUtil.getInstance().getWidgetControlBarHeader(null,widgetTitle);								
			}
			
			return controlBarHeader;
		}
		
		private function createControlBar():void
		{
			if (controlBar == null) 
			{
				controlBar = new HBox();
				controlBar.percentWidth = 100;
				controlBar.styleName = "saveWidgetControlBar";				
				
				/*
				* Header
				*/
				controlBar.addChild(createControlBarHeader());
				
				/*
				* Print Button
				*/
				saveButton = new Button();
				saveButton.label = "Save";
				saveButton.setStyle("icon", saveIconClass);
				saveButton.addEventListener(MouseEvent.CLICK, saveBtnClickHandler);
				controlBar.addChild(saveButton);
				/*
				* Reset Button
				*/
				resetButton = new Button();
				resetButton.label = "Reset";
				resetButton.addEventListener(MouseEvent.CLICK, resetBtnClickHandler);
				controlBar.addChild(resetButton);
				
				addChild(controlBar);
				
			}
		}
		
		/**
		 * Creates center panel containing the widget. This is overridden by sub classes.
		 * 
		 */
		override protected function createCenterPanel():void
		{
			buildForm();
		}
		
		/**
		 * Builds the actual widget. This is overridden by sub classes.
		 * 
		 */
		protected function buildForm():void
		{		
			
		}
		
		private function saveBtnClickHandler(event:MouseEvent):void {
			if(!isLightWeight) {
				save();
			}
		}
		
		
		private function resetBtnClickHandler(event:MouseEvent):void {
			if(!isLightWeight) {
				reset();
			}
		}
	}
}