package gov.va.med.edp.view.worksheet
{	
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.MouseEvent;
	
	import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
	
	import mx.containers.HBox;
	import mx.controls.Button;
	import mx.controls.Label;
	import mx.printing.FlexPrintJob;
	/**
	 * Creates the control bar for the worksheets
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class LoadWorkSheetWidget extends WorkSheetWidget
	{	
		/**
		 *  The print job from flex to achieve print function.
		 */
		protected var printJob:FlexPrintJob;
		/**
		 *  The title.
		 */
		protected var lblTitle:Label;
		/**
		 *  The control bar control.
		 */
		protected var controlBar:HBox;
		/**
		 *  The control bar header control.
		 */
		protected var controlBarHeader:HBox;
		/**
		 *  The print button control.
		 */
		protected var printButton:Button;
		/**
		 *  The load button control.
		 */
		protected var loadButton:Button;
		/**
		 *  The clear button control.
		 */
		protected var clearButton:Button;
		[Embed(source="/assets/print_16x16.png")]
		private var printIconClass: Class;
		[Embed(source="/assets/refresh16x16.png")]
		private var loadIconClass: Class;
		

		/**
		 * This widget is used for loading and viewing data.
		 * @param printable - Wether or not this widget can be printed.
		 * @param loadEvent - Event to dispatch the load call.
		 */
		public function LoadWorkSheetWidget(printable:Boolean = false,
											loadEvent:CairngormEvent = null)
		{
			super(loadEvent);
			this.styleName = "worksheetLoadWidget";
		}
		
		/**
		 * Calls the associated load call to get the data from VistA.
		 */
		protected function load():void
		{
			
			//var executingEvent:WorkSheetWidgetEvent = new WorkSheetWidgetEvent(WorkSheetWidgetEvent.EXECUTING);
			executingEvent.dispatch();	
			
			if (event != null)
			{
				event.dispatch();	
			}
		}				
		
		/**
		 * Prints the data associated with this widget.
		 */
		protected function print():void
		{			
		}
		/**
		 * Creates the control bar.
		 */			
		override protected function createNorthPanel():void
		{
			createControlBar();
		}
		
		/**
		 * Creates the control bar header.
		 */
		protected function createControlBarHeader():HBox
		{			
			if (controlBarHeader == null) 
			{							
				controlBarHeader = WorkSheetUtil.getInstance().getWidgetControlBarHeader(event.type,widgetTitle);								
			}
			
			return controlBarHeader;
		}
		
		/**
		 * Creates the actual control bar with print, load and clear buttons.
		 */
		protected function createControlBar():void
		{
			if (controlBar == null) 
			{
				controlBar = new HBox();
				controlBar.percentWidth = 100;
				controlBar.styleName = "loadWidgetControlBar";				
							
				/*
				* Header
				*/
				controlBar.addChild(createControlBarHeader());
				
				/*
				* Print Button
				*/
				printButton = new Button();
				printButton.label = "Print";
				printButton.setStyle("icon", printIconClass);
				printButton.addEventListener(MouseEvent.CLICK, printBtnClickHandler);
				controlBar.addChild(printButton);
				/*
				* Load Button
				*/
				loadButton = new Button();
				loadButton.label = "Load";
				loadButton.setStyle("icon", loadIconClass);
				loadButton.addEventListener(MouseEvent.CLICK, loadBtnClickHandler);
				controlBar.addChild(loadButton);
				/*
				* Clear Button
				*/
				clearButton = new Button();
				clearButton.label = "Clear";
				clearButton.addEventListener(MouseEvent.CLICK, clearBtnClickHandler);
				controlBar.addChild(clearButton);
				
				addChild(controlBar);
				
			}
		}
		
		/**
		 * Enables the print, clear, or load buttons.
		 */
		protected override function entryChanged():void			
		{
			super.entryChanged();
			
			if(model.logEdit.entry.dfn == '' || model.logEdit.entry.dfn == null ) {
				if (this.printButton != null) {
					printButton.enabled = false;
				}
				if (this.clearButton != null) {
					clearButton.enabled = false;
				}
				if (this.loadButton != null) {
					loadButton.enabled = false;
				}
			} 		
		}
		
		private function printBtnClickHandler(event:MouseEvent):void {
			if(!isLightWeight) {
				print();
			}
		}
		
		private function loadBtnClickHandler(event:MouseEvent):void {
			if(!isLightWeight) {
				reset();
				load();
			}
		}
		
		private function clearBtnClickHandler(event:MouseEvent):void {
			if(!isLightWeight) {
				reset();
			}
		}
		
		
		/**
		 * Sets the buttons to indicate enabled or disabled.
		 */
		protected override function loaded():void
		{
			printButton.enabled = true;
			loadButton.enabled = false;
			clearButton.enabled = true;
		}
		
		/**
		 * Sets the buttons to indicate enabled or disabled at widget initialization.
		 */
		protected override function widget_initialized():void
		{	
			printButton.enabled = false;
			loadButton.enabled = true;
			clearButton.enabled = false;
		}
	}
}
