package gov.va.med.edp.view.config
{
	import gov.va.med.edp.vo.RoomBedVO;
	
	import mx.collections.ArrayCollection;
	import mx.validators.ValidationResult;
	import mx.validators.Validator;
	/**
	 * Holds the duplicate name validator information. 
	 */
	public class DuplicateNameValidator extends Validator
	{
		[Bindable]
		/**
		 * The collection of beds. 
		 */
		public var beds:ArrayCollection;

		[Bindable]
		/**
		 * The selected bed object. 
		 */
		public var selectedBed:RoomBedVO;
	
		[Bindable]
		/**
		 * The field identifier. 
		 */
		public var field:String;

		/**
		 * The collection of results. 
		 */
		private var results:Array;
		/**
		 *  Constructor
		 *
		 */
        public function DuplicateNameValidator() {
            super();
        }
		/**
		 *  Validates the duplicate
		 * @param value as string to validate.
		 *
		 */
    	private function isDuplicate(value:String):Boolean {
    		if (selectedBed == null) return false;
    		var skipIndex:int = beds.getItemIndex(selectedBed);
    		for (var i:int = 0; i < beds.length; i++) {
    			if (i == skipIndex) continue;
                var bed:RoomBedVO = beds[i] as RoomBedVO;
                
                if (bed[field].toLowerCase() == value.toLowerCase()) return true;
            }
            return false;
    	}
 
		/**
		 *  Validates the object values
		 * @param value  the values to validate.
		 *
		 */
        override protected function doValidation(value:Object):Array {
            var inputValue:String = String(value);

            results = [];
			results = super.doValidation(value);        
            if (results.length > 0)
                return results;
        
        	if (isDuplicate(inputValue)) {
        		results.push(new ValidationResult(true, null, "duplicate", "Duplicate name is not allowed."));
        		return results;
        	}
        
            return results;
        }

	}
}