/* Vista.as */

package gov.va.med.edp.util
{
	import mx.collections.ICollectionView;
	import mx.formatters.DateFormatter;	
	
	/**
	 * Helper methods for VistA interaction.
	 *
	 */
	public class Vista
	{
		private static const DT_FORMAT: String = "D MMM YY J:NN";
				
		/*
		Searches a collection for the index of the item that matches that data value
		*/
		/**
		 * Searches a collection for the index of the item that matches that data value
		 * @param collection for collection
		 * @param value for selection
		 * 
		 */
		public static function locateIndex(collection: ICollectionView, 
			value: Object, property: String = "data"): int
		{
			for (var i:int; i < collection.length; i++) {
				var item:Object = collection[i];
				if (item.hasOwnProperty(property) && (item[property] == value)) return i;
			}
			return -1;
		}

		/*
		Returns the numeric identifier for an object at an index in a collection
		*/
		/**
		 * Returns the numeric identifier for an object at an index in a collection
		 * @param collection for collection
		 * @param value for selection
		 * 
		 */
		public static function getIDFieldAtIndex(collection: ICollectionView, 
			index: int, property: String = "data"): Number
		{
			if (index < 0) return NaN;
			if (index < collection.length) {
				var item:Object = collection[index];
				if (item.hasOwnProperty(property)) return item[property];
			}
			return NaN;
		}
		/**
		 * get the date
		 * @param fmDT for date
		 * 
		 * 
		 */
		public static function FMtoDate(fmDT: String): Date
		{
			if (fmDT.length < 7) {
				return null;
			}
			
			var x:String = fmDT + "00000";
			var y:int = int(x.substr(0,3)) + 1700;
			var m:int = int(x.substr(3,2)) - 1;
			var d:int = int(x.substr(5,2));
			var h:int = int(x.substr(8,2));
			var n:int = int(x.substr(10,2));
			return new Date(y,m,d,h,n);
		}

		/**
		 * Get the date and seconds.
		 * @param fmDT for date
		 * 
		 * 
		 */
		public static function FMtoDateSeconds(fmDT: String): Date
		{
			if (fmDT.length < 7) {
				return null;
			}
			
			var x:String = fmDT + "00000";
			var y:int = int(x.substr(0,3)) + 1700;
			var m:int = int(x.substr(3,2)) - 1;
			var d:int = int(x.substr(5,2));
			var h:int = int(x.substr(8,2));
			var n:int = int(x.substr(10,2));
			var s:int = int(x.substr(12,2));
			return new Date(y,m,d,h,n,s);
		}
		
		/**
		 * from  the date
		 * @param aDate for date
		 * 
		 * 
		 */
		public static function DatetoFM(aDate: Date): String
		{
			if (aDate == null) return "";
			
			var y:int = (aDate.fullYear - 1700) * 10000;
			var m:int = (aDate.month + 1) * 100;
			var d:int = aDate.date;
			var h:String = "00" + String(aDate.hours);
			var n:String = "00" + String(aDate.minutes);

			if ((y+m+d) == 0) return "";
			
			if ((aDate.hours + aDate.minutes) > 0) {
				return String(y+m+d) + "." + h.substr(-2,2) + n.substr(-2,2); 
			} else {
				return String(y+m+d);
			}
		}
		
		/**
		 * from  the date
		 * @param aDate for date
		 * 
		 * 
		 */
		public static function DatetoFM_Seconds(aDate: Date): String
		{
			if (aDate == null) return "";
			
			var y:int = (aDate.fullYear - 1700) * 10000;
			var m:int = (aDate.month + 1) * 100;
			var d:int = aDate.date;
			var h:String = "00" + String(aDate.hours);
			var n:String = "00" + String(aDate.minutes);
			var s:String = "00" + String(aDate.seconds);
			
			if ((y+m+d) == 0) return "";
			
			if ((aDate.hours + aDate.minutes + aDate.seconds) > 0) {
				return String(y+m+d) + "." + h.substr(-2,2) + n.substr(-2,2) + s.substr(-2,2); 
			} else {
				return String(y+m+d);
			}
		}
		/**
		 * format  the date
		 * @param aDate for date
		 * 
		 * 
		 */
		public static function formattedDate(aDate: Date, formatString:String=null): String
		{
			if (aDate == null) {
				return "";
			}
			
			var formatter:DateFormatter = new DateFormatter();
			if (formatString != null){
				formatter.formatString = formatString;
			} else {
			formatter.formatString = DT_FORMAT;
			}
			
			return formatter.format(aDate);
		}
		/**
		 * verification
		 * @param str validation
		 * 
		 * 
		 */
		public static function getBooleanValueForString(str: String): Boolean
		{
			if (str == "true") {
				return true;
			}
			return false;
		}		
	}
}