package gov.va.med.edp.util
{
	import gov.va.med.edp.control.reports.ReportDownloadEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.view.reports.print.ReportDataGridPrintView;
	import gov.va.med.edp.vo.reports.ReportParamsVO;
	
	import mx.collections.ArrayCollection;
	import mx.containers.HBox;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.Application;
	import mx.formatters.DateFormatter;
	import mx.printing.FlexPrintJob;
	import mx.utils.ObjectUtil;
	
	/**
	 * Defines helper modules (such as proper Date formats for EDIS reports)
	 */
	public class ReportUtil
	{
		private static var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		public static const millisecondsPerHour:int = 1000 * 60 * 60;
		private static const DT_FORMAT: String = "DD MMM YY JJ:NN";
		private static const ACCESSIBLE_DT_FORMAT: String = "MMMM DD, YYYY JJ:NN";

		/**
		 * Create Report lables for reports
		 * @param initilizationText for header
		 *
		 */		
		static public function buildReportLabelText(initilizationText:String): String
		{
			var startDate:String = Vista.formattedDate(model.reports.startDate, DT_FORMAT);
			var stopDate:String = Vista.formattedDate(model.reports.stopDate, DT_FORMAT);
			var lbltext:String = initilizationText + " from " + startDate + " to " + stopDate;
 			return lbltext;
		}
		
		/**
		 * Create Report lables for reports for avalable dates
		 * @param initilizationText for header
		 *
		 */	
		static public function accessibleReportLabelText(initilizationText:String): String
		{
			var startDate:String = Vista.formattedDate(model.reports.startDate, ACCESSIBLE_DT_FORMAT);
			var stopDate:String = Vista.formattedDate(model.reports.stopDate, ACCESSIBLE_DT_FORMAT);
			var lbltext:String = initilizationText + " from " + startDate + " to " + stopDate;
 			
 			return lbltext;
		}
		/**
		 * date and time verication and manipulation
		 * @param startDate for date
		 *
		 */	
		static public function calculateEndTimeForShiftReport(startDate:Date): Date
		{
			var endDate:Date = new Date(startDate.getTime());
			endDate.setTime(endDate.getTime() + (24* millisecondsPerHour));
			return endDate;
		}
		/**
		 * date and time verication and manipulation
		 * @param startDate for date
		 *
		 */
		static public function formatReportDate(item: Object, column: DataGridColumn): String
		{
			var dataField:String = column.dataField;
			if ((item != null) && (item[dataField] != null)) {
				return Vista.formattedDate(item[dataField], "M/D/YY JJ:NN");					
			} else {
				return "";
			}
		}
		/**
		 * date and time verication and manipulation
		 * 
		 *
		 */
		static public function formatRestored(item: Object, column: DataGridColumn): String
		{
			var dataField:String = column.dataField;
			if ((item != null) && (item[dataField] != null)) {
				if (item[dataField] == 1) {
					return "Yes";
				} else {
					return "No";
				}					
			} else {
				return "Error";
			}
		}
		/**
		 * date and time verication and manipulation
		 *
		 *
		 */
		static public function sortTimeInDates(obj1:Object, obj2:Object):int
		{
			var date1: Date = obj1.timeIn;
			var date2: Date = obj2.timeIn;
			return ObjectUtil.dateCompare(date1, date2);
		} 		
		/**
		 * date and time verication and manipulation
		 * 
		 *
		 */
		static public function sortTimeOutDates(obj1:Object, obj2:Object):int
		{
			var date1: Date = obj1.timeOut;
			var date2: Date = obj2.timeOut;
			return ObjectUtil.dateCompare(date1, date2);
		} 				
		/**
		 * allow for export
		 * @param reportName to export
		 * @param  reportId to export
		 *
		 */	
		static public function exportReport(reportName:String, reportId:String=null): void
		{
			var reportEvent: ReportDownloadEvent = new ReportDownloadEvent(ReportDownloadEvent.EVENT_DOWNLOAD_REPORT);
			var reportParams: ReportParamsVO = new ReportParamsVO();
			reportParams.reportName = reportName;
			reportParams.startDate = new Date(model.reports.startDate);	
			reportParams.stopDate = new Date(model.reports.stopDate);
			reportParams.id = reportId;
			reportEvent.reportParams = reportParams;
			reportEvent.dispatch();
		}		
		/**
		 * availabe for export
		 * @param button enabler
		 *
		 */	
		static public function setExportButtonState(button:HBox): void
		{
			button.visible = model.session.canExport;
		}	
		
		static public function printProviderGrid(printJob:FlexPrintJob, gridColumns:Array, dataProviderForGrid:Object, subHeadings:ArrayCollection, gridFontSize:int=8, reportHeaderFontSize:int=8):void{
			// Create a FormPrintView control as a child of the current view.
			var dataGridPrintView:ReportDataGridPrintView = new ReportDataGridPrintView();
			Application.application.addChild(dataGridPrintView);
			
			var d:Date = new Date();
			var df:DateFormatter = new DateFormatter();
			df.formatString = "D MMM YY J:NN";
			var dateHeader:String = df.format(d);
				
			//Set the print view properties.
			//FlexPrintJobScaleType
			dataGridPrintView.width=printJob.pageWidth;
			dataGridPrintView.height=printJob.pageHeight;
			dataGridPrintView.lblHeaderText = dateHeader;

			dataGridPrintView.subHeadings = subHeadings;
//			dataGridPrintView.subHeaderText1 = reportHeaderText;
//			dataGridPrintView.subheader1.lblReportHeader.setStyle('textAlign', 'left');
//			dataGridPrintView.subheader1.lblReportHeader.setStyle('fontSize', '7');

			// Set the data provider of the FormPrintView component's data grid
			// to be the data provider of the displayed data grid.
			dataGridPrintView.reportDataGrid.columns = gridColumns;
			dataGridPrintView.reportDataGrid.dataProvider = dataProviderForGrid;
			dataGridPrintView.reportDataGrid.setStyle('fontSize', gridFontSize);
			dataGridPrintView.header.setStyle('fontSize', reportHeaderFontSize);
			// Create a single-page image.
			dataGridPrintView.showPage("single");
			// If the print image's data grid can hold all the provider's rows,
			// add the page to the print job.
			if(!dataGridPrintView.reportDataGrid.validNextPage)
			{
				printJob.addObject(dataGridPrintView);
			}
				// Otherwise, the job requires multiple pages.
			else
			{
				// Create the first page and add it to the print job.
				dataGridPrintView.showPage("first");
				printJob.addObject(dataGridPrintView);
				dataGridPrintView.pageNumber++;
				// Loop through the following code until all pages are queued.
				while(true)
				{
					// Move the next page of data to the top of the print grid.
					dataGridPrintView.reportDataGrid.nextPage();
					dataGridPrintView.showPage("last");
					// If the page holds the remaining data, or if the last page
					// was completely filled by the last grid data, queue it for printing.
					// Test if there is data for another PrintDataGrid page.
					if(!dataGridPrintView.reportDataGrid.validNextPage)
					{
						// This is the last page; queue it and exit the print loop.
						printJob.addObject(dataGridPrintView);
						break;
					}
					else
						// This is not the last page. Queue a middle page.
					{
						dataGridPrintView.showPage("middle");
						printJob.addObject(dataGridPrintView);
						dataGridPrintView.pageNumber++;
					}
				}
			}
			// All pages are queued; remove the FormPrintView control to free memory.
			Application.application.removeChild(dataGridPrintView);
		}
		
		
		static public function printDataGrid(printJob:FlexPrintJob, gridColumns:Array, dataProviderForGrid:Object, reportHeaderText: String, gridFontSize:int=8, reportHeaderFontSize:int=8):void{
	                // Create a FormPrintView control as a child of the current view.
            var dataGridPrintView:ReportDataGridPrintView = new ReportDataGridPrintView();
           Application.application.addChild(dataGridPrintView);

		   //   for testing only
//		   model.logEdit.entry.name = "Dash, Fly";
//		   model.logEdit.entry.ssn = "102546789";
//		   model.logEdit.entry.inTS = new Date();
		   //   for testing only
		   
		   var d:Date = new Date();
		   var df:DateFormatter = new DateFormatter();
		   df.formatString = "D MMM YY J:NN";
		   var dateHeader:String = df.format(d);
		   		   
            //Set the print view properties.
            //FlexPrintJobScaleType
            dataGridPrintView.width=printJob.pageWidth;
            dataGridPrintView.height=printJob.pageHeight;
            dataGridPrintView.lblHeaderText = dateHeader;
			
			var headings:ArrayCollection = new ArrayCollection([]);
//			if (model.logEdit.entry != null) {
//				//  Add patient data to the header
//				var sa:Array;
//				sa = model.logEdit.entry.name.split(",");
//				if (sa.length > 0) {
//					var s2:String = "";
//					if (model.logEdit.entry.ssn != null) {
//						s2 = model.logEdit.entry.ssn.substr(-4,4);
//					}
//					headings.addItem(reportHeaderText+" for "+sa[1]+"  "+sa[0].substr(0,1)+s2);
//					headings.addItem("Time in: "+df.format(model.logEdit.entry.inTS));
//				}
//			}
			dataGridPrintView.subHeadings = headings;
			
            // Set the data provider of the FormPrintView component's data grid
            // to be the data provider of the displayed data grid.
            dataGridPrintView.reportDataGrid.columns = gridColumns;
            dataGridPrintView.reportDataGrid.dataProvider = dataProviderForGrid;
            dataGridPrintView.reportDataGrid.setStyle('fontSize', gridFontSize);
            dataGridPrintView.header.setStyle('fontSize', reportHeaderFontSize);
            // Create a single-page image.
            dataGridPrintView.showPage("single");
            // If the print image's data grid can hold all the provider's rows,
            // add the page to the print job.
            if(!dataGridPrintView.reportDataGrid.validNextPage)
            {
                printJob.addObject(dataGridPrintView);
            }
            // Otherwise, the job requires multiple pages.
            else
            {
                // Create the first page and add it to the print job.
                dataGridPrintView.showPage("first");
                printJob.addObject(dataGridPrintView);
                dataGridPrintView.pageNumber++;
                // Loop through the following code until all pages are queued.
                while(true)
                {
                    // Move the next page of data to the top of the print grid.
                    dataGridPrintView.reportDataGrid.nextPage();
                    dataGridPrintView.showPage("last");
                    // If the page holds the remaining data, or if the last page
                    // was completely filled by the last grid data, queue it for printing.
                    // Test if there is data for another PrintDataGrid page.
                    if(!dataGridPrintView.reportDataGrid.validNextPage)
                    {
                        // This is the last page; queue it and exit the print loop.
                        printJob.addObject(dataGridPrintView);
                        break;
                    }
                    else
                    // This is not the last page. Queue a middle page.
                    {
                        dataGridPrintView.showPage("middle");
                        printJob.addObject(dataGridPrintView);
                        dataGridPrintView.pageNumber++;
                    }
                }
            }
            // All pages are queued; remove the FormPrintView control to free memory.
            Application.application.removeChild(dataGridPrintView);
		}
				
	}
}