package gov.va.med.edp.util
{
	import mx.core.Application;
	import gov.va.med.edp.model.TrackingModelLocator;
	import mx.printing.FlexPrintJob;
	import gov.va.med.edp.view.reports.print.ReportDataGridPrintView;
	import gov.va.med.edp.vo.reports.ReportParamsVO;
	import mx.core.Container;
	/**
	 * Defines helper modules (such as proper Date formats for EDIS printing)
	 * @author useruseruser12
	 * 
	 */
	public class PrintUtil
	{
		
		private static var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		public static const millisecondsPerHour:int = 1000 * 60 * 60;
		private static const DT_FORMAT: String = "DD MMM YY JJ:NN";
		private static const ACCESSIBLE_DT_FORMAT: String = "MMMM DD, YYYY JJ:NN";
		
		/**
		 * Prints the supplied container.
		 * @param printJob - Printjob associated.
		 * @param container - The Container of information.
		 * @param headerText - Header to be displayed.
		 * @param footerText - Footer to be displayed.
		 * @param reportHeaderFontSize - The header font size.
		 * 
		 */
		static public function printContainer(printJob:FlexPrintJob, 
											 container:Container,
											 headerText: String, 
											 footerText: String,
											 reportHeaderFontSize:int=8):void
		{
			if(container != null)
			{
				printJob.addObject(container);
			}
		}
		
		/**
		 * Prints the supplied grid.
		 * @param printJob - Printjob associated.
		 * @param gridColumns - Columns associated with the grid.
		 * @param dataProviderForGrid - Dataprovider for the grid.
		 * @param reportHeaderText - Header to be displayed.
		 * @param gridFontSize - Grid font size.
		 * @param reportHeaderFontSize - The header font size.
		 * 
		 */
		static public function printDataGrid(printJob:FlexPrintJob,
											 gridColumns:Array,
											 dataProviderForGrid:Object,
											 reportHeaderText: String,
											 gridFontSize:int=8,
											 reportHeaderFontSize:int=8):void
		{
			// Create a FormPrintView control as a child of the current view.
			var dataGridPrintView:ReportDataGridPrintView = new ReportDataGridPrintView();
			Application.application.addChild(dataGridPrintView);
			
			//Set the print view properties.
			//FlexPrintJobScaleType
			dataGridPrintView.width=printJob.pageWidth;
			dataGridPrintView.height=printJob.pageHeight;
			dataGridPrintView.lblHeaderText = reportHeaderText;
			// Set the data provider of the FormPrintView component's data grid
			// to be the data provider of the displayed data grid.
			dataGridPrintView.reportDataGrid.columns = gridColumns;
			dataGridPrintView.reportDataGrid.dataProvider = dataProviderForGrid;
			dataGridPrintView.reportDataGrid.setStyle('fontSize', gridFontSize);
			dataGridPrintView.header.setStyle('fontSize', reportHeaderFontSize);
			// Create a single-page image.
			dataGridPrintView.showPage("single");
			// If the print image's data grid can hold all the provider's rows,
			// add the page to the print job.
			if(!dataGridPrintView.reportDataGrid.validNextPage)
			{
				printJob.addObject(dataGridPrintView);
			}
				// Otherwise, the job requires multiple pages.
			else
			{
				// Create the first page and add it to the print job.
				dataGridPrintView.showPage("first");
				printJob.addObject(dataGridPrintView);
				dataGridPrintView.pageNumber++;
				// Loop through the following code until all pages are queued.
				while(true)
				{
					// Move the next page of data to the top of the print grid.
					dataGridPrintView.reportDataGrid.nextPage();
					dataGridPrintView.showPage("last");
					// If the page holds the remaining data, or if the last page
					// was completely filled by the last grid data, queue it for printing.
					// Test if there is data for another PrintDataGrid page.
					if(!dataGridPrintView.reportDataGrid.validNextPage)
					{
						// This is the last page; queue it and exit the print loop.
						printJob.addObject(dataGridPrintView);
						break;
					}
					else
						// This is not the last page. Queue a middle page.
					{
						dataGridPrintView.showPage("middle");
						printJob.addObject(dataGridPrintView);
						dataGridPrintView.pageNumber++;
					}
				}
			}
			// All pages are queued; remove the FormPrintView control to free memory.
			Application.application.removeChild(dataGridPrintView);
		}
	}
}