package gov.va.med.edp.util {
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;
import flash.utils.getTimer;

import gov.va.med.edp.control.ClearUnsavedViewsModelEvent;
import gov.va.med.edp.model.TrackingModelLocator;

import mx.core.Application;
import mx.core.SoundAsset;

/**
 * Timer controls the application timeout state.
 *
 */
public class InactivityTimeout {
    //	private var timeOutInterval:uint;
    private var confirmInterval:uint;
    private var sessionTimeOutTimer:Timer;

    private var confirmTimer:Timer;
    private var countdownTimer:Timer = new Timer(1000)
    private var lastActivityTime:Number = 0;
    private var counter:uint = 0;
    private var timersStarted:Boolean = false;
    
    [Embed(source="Timeout.mp3")]
    private var alertSound: Class;
    
    [Bindable]
    public var status:String = "";

    private var model:TrackingModelLocator = TrackingModelLocator.getInstance();

	/**
	 *   Constructor.
	 */
	public function InactivityTimeout() 
	{
	}
	/**
	 * STARTING TO MONITOR THE SESSION
	 * 
	 *
	 */
    public function start():void {
        sessionTimeOutTimer = new Timer(model.session.timeOut);
        sessionTimeOutTimer.addEventListener(TimerEvent.TIMER, onTimeOutTimer);

        confirmTimer = new Timer(model.session.countDown);
        confirmTimer.addEventListener(TimerEvent.TIMER, onConfirmTimer);
        countdownTimer.addEventListener(TimerEvent.TIMER, onCountdownTimer);

        confirmInterval = model.session.countDown;

        Application.application.addEventListener("keyDown", activity);
        Application.application.addEventListener("mouseMove", activity);

        sessionTimeOutTimer.start();
        timersStarted = true;
    }

	/**
	 * reset THE SESSION
	 * 
	 *
	 */
    public function reset():void
    {
        lastActivityTime = getTimer();
        //For some reason the reset method in the Timer class is flaky..Not reliable..
        if (sessionTimeOutTimer != null) {
            sessionTimeOutTimer.stop();
            sessionTimeOutTimer.start();
        }

        if (timersStarted && confirmTimer.running) {
            confirmTimer.stop();
            countdownTimer.stop();
            counter = 0;
            status = "";
        }
    }

    private function activity(event:Event):void {
        reset(); 
    }

    private function onTimeOutTimer(event:TimerEvent):void
    {
        confirmTimer.start();
        countdownTimer.start();
    }

	/**
	 * timeout message THE SESSION
	 * 
	 *
	 */
    private function onConfirmTimer(event:TimerEvent):void
    {
        status = "Session timed out..Redirecting to Logout...";
        //Make sure you clear out any unsaved views
        //other wise the javascript will not let you navigate out..
        var clearUnsavedViewsEvent: ClearUnsavedViewsModelEvent = new ClearUnsavedViewsModelEvent(ClearUnsavedViewsModelEvent.EVENT_CLEAR_UNSAVED_VIEWS);
        clearUnsavedViewsEvent.dispatch();

        Application.application.removeEventListener("keyDown", reset);
        Application.application.removeEventListener("mouseMove", reset);

        confirmTimer.stop();
        countdownTimer.stop();
        
        model.logout();
    }
	/**
	 * Warning THE SESSION
	 * 
	 *
	 */
    private function onCountdownTimer(event:TimerEvent):void
    {
        counter++;
        var seconds:String = String(confirmInterval / 1000 - counter);
 
 		trace("Counter: ", counter);
 		if (counter == 1) playAlertSound();
        status = "EDIS has been idle and will close in " + seconds + " seconds.";
    }
    
	/**
	 * make noise for THE SESSION
	 * 
	 *
	 */
    private function playAlertSound(): void
    {
    	var chime: SoundAsset = new alertSound() as SoundAsset;
    	chime.play(0,1);
    }
}
}