package gov.va.med.edp.util
{
	/**
	 * A helper class to manipulate Date objects (adding or subtracting time from a given Date)
	 */
	public class DateMath {
		// add to date
		public static function addWeeks(date:Date, weeks:Number):Date {
			return addDays(date, weeks*7);
		}
		
		public static function addDays(date:Date, days:Number):Date {
			return addHours(date, days*24);
		}
		
		public static function addHours(date:Date, hrs:Number):Date {
			return addMinutes(date, hrs*60);
		}
		
		public static function addMinutes(date:Date, mins:Number):Date {
			return addSeconds(date, mins*60);
		}
		
		public static function addSeconds(date:Date, secs:Number):Date {
			var mSecs:Number = secs * 1000;
			var sum:Number = mSecs + date.getTime();
			return new Date(sum);
		}
		
		// subtract from date
		public static function subWeeks(date:Date, weeks:Number):Date {
			return subDays(date, weeks*7);
		}
		
		public static function subDays(date:Date, days:Number):Date {
			return subHours(date, days*24);
		}
		
		public static function subHours(date:Date, hrs:Number):Date {
			return subMinutes(date, hrs*60);
		}
		
		public static function subMinutes(date:Date, mins:Number):Date {
			return subSeconds(date, mins*60);
		}
		
		public static function subSeconds(date:Date, secs:Number):Date {
			var mSecs:Number = secs * 1000;
			var subtraction:Number = date.getTime() - mSecs;
			return new Date(subtraction);
		}
	}

}