package gov.va.med.edp.util
{
	import flash.events.Event;
	
	import gov.va.med.edp.control.ChangeLogEntryFieldEvent;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.pt.demog.view.SelectPatientEvent;
	
	import mx.controls.ComboBox;
	import mx.controls.List;
	import mx.controls.TextInput;
	import mx.events.CalendarLayoutChangeEvent;

	/**
	 * Watches for changes in various data fields throughout the app, and applies them to VistA.
	 *
	 */
	public class ChangeWatcher
	{
		

		/**
		 *   Constructor.
		 */
		public function ChangeWatcher() 
		{
		}
		
		/**
		 * CHANGE THE LOG FIELD
		 * @param changeField for the event
		 *
		 */
		public static function changeField(event: Event): void
		{
			var changeEvent: ChangeLogEntryFieldEvent = 
				new ChangeLogEntryFieldEvent(ChangeLogEntryFieldEvent.EVENT_CHANGE_LOG_ENTRY_FIELD);
			changeEvent.field = event.currentTarget.id;
			if (event.currentTarget is ComboBox) {
				changeEvent.value = comboBoxValue(ComboBox(event.currentTarget));
				changeEvent.label = comboBoxLabel(ComboBox(event.currentTarget));
				changeEvent.reference = comboBoxRef(ComboBox(event.currentTarget));
			}
			if (event.currentTarget is List) {
				changeEvent.value = listValue(List(event.currentTarget));
				changeEvent.label = listLabel(List(event.currentTarget));
				changeEvent.reference = listRef(List(event.currentTarget));
			}
			if (event.currentTarget is TextInput) {
				changeEvent.value = TextInput(event.currentTarget).text;
				//changeEvent.value = (changeEvent.value == "") ? "   " : changeEvent.value;
				changeEvent.label = changeEvent.value;
			}
			if (event is SelectPatientEvent) {
				changeEvent.value = SelectPatientEvent(event).patient;
				changeEvent.field = "patient";
			}
			if (event is CalendarLayoutChangeEvent) {
				changeEvent.value = CalendarLayoutChangeEvent(event).newDate;
				changeEvent.field = event.currentTarget.id;
			}
			changeEvent.dispatch();
		}
		
		/**
		 * Submit the CPE field selection
		 * @param changeField for the event
		 *
		 */
		public static function submitField(event: Event): void
		{
			var model:TrackingModelLocator = TrackingModelLocator.getInstance();

			var value:*;
			var label:String = "";
			var id:String = "";

			id = event.currentTarget.id;
			if (event.currentTarget is ComboBox) {
				value = comboBoxValue(ComboBox(event.currentTarget));
				label = comboBoxLabel(ComboBox(event.currentTarget));
			}
			if (event.currentTarget is List) {
				value = listValue(List(event.currentTarget));
				label = listLabel(List(event.currentTarget));
			}
			if (event.currentTarget is TextInput) {
				value = TextInput(event.currentTarget).text;
				label = value;
			}
			
			model.logEdit.dirty = true;
			model.displayVisitSummary = false;
			
			switch(id)
			{
				case "complaint":
					model.logEdit.entry.complaint = value;
					break;
				case "bed":
					model.logEdit.entry.bed = value;
					break;
				case "acuity":
					model.logEdit.entry.acuity = value;
					break;
				case "stati":
					model.logEdit.entry.status = value;
					break;
				case "provider":
					model.logEdit.entry.provider = value;
					break;
				case "resident":
					model.logEdit.entry.resident = value;
					break;
				case "nurse":
					model.logEdit.entry.nurse = value;
					break;
				case "comment":
					model.logEdit.entry.comment = value;
					break;
				case "disposition":
					model.logEdit.entry.disposition = value;
					model.entryRemoveReady();
					break;
			} // switch			
			
			var e: TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_SAVE_AND_REFRESH_DISPLAYBOARD);
			e.dispatch();			

		}
		
		private static function listValue(box: List): *
		{
			if (box.selectedItem == null) return -1;
			return box.selectedItem.data;
		}
		
		private static function listLabel(box: List): String
		{
			if (box.selectedItem == null) return "";
			return box.selectedItem.label;
		}
		
		private static function listRef(box: List): String
		{
			if (box.selectedItem == null) return "";
			if (box.selectedItem.hasOwnProperty("reference")) {
				return box.selectedItem.reference;
			} else {
				return "";
			}
		}
		
		private static function comboBoxValue(box: ComboBox): *
		{
			if (box.selectedItem == null) return -1;
			return box.selectedItem.data;
		}
		
		private static function comboBoxLabel(box: ComboBox): String
		{
			if (box.selectedItem == null) return "";
			return box.selectedItem.label;
		}
		
		private static function comboBoxRef(box: ComboBox): String
		{
			if (box.selectedItem == null) return "";
			if (box.selectedItem.hasOwnProperty("reference")) {
				return box.selectedItem.reference;
			} else {
				return "";
			}
		}
	}
}