package gov.va.med.edp.util
{
import flash.accessibility.Accessibility;
import flash.accessibility.AccessibilityProperties;
import flash.utils.setTimeout;

import mx.core.UIComponent;


[Bindable]
/**
 * Manage accessibility behavior.
 * 
 *
 */	
public class AccessibilityTools
{

    //----------------------------------------------------------------
    //
    //  Class constants
    //
    //-----------------------------------------------------------------

    private static const ACC_READ_DELAY:int = 2000;

	/**
	 *   Constructor.
	 */
	public function AccessibilityTools() 
	{
	}

    /**
     *  Function: accessComponentName()
     *  Parameters:
     *      component:UIComponent - Screen component reference
     *      accessName:String - Text to be read by JAWS
     *  Description:
     *      Generic functionality for reading flex accessible components
     *      when JAWS accessible feature(508) is used.
     *  Created by: jtorreno
     *  Date: 2008.02.08
     *
     **/
    public static function accessComponentName(component:UIComponent,
                                               accessName:String): void
    {

        if ((component != null) && (accessName != null)) {
            component.accessibilityProperties =
            new AccessibilityProperties();
            component.accessibilityProperties.name = accessName;

            setTimeout(updateAccessibleProperties, ACC_READ_DELAY);
        }

    }

    /**
     *  Function: updateAccessibleProperties()()
     *  Parameters:
     *        NONE
     *  Description:
     *      Generic functionality for updating accessible properties
     *      when JAWS accessible feature(508) is used.
     *  Created by: jtorreno
     *  Date: 2008.02.15
     *
     **/

    private static function updateAccessibleProperties(): void
    {
        if (Accessibility.active) {
            Accessibility.updateProperties();
        }
    }

    /**
     *  Function: accessComponentDescription()
     *  Parameters:
     *      component:UIComponent - Screen component reference
     *      accessName:String - Text to be read by JAWS
     *  Description:
     *      Generic functionality for reading flex accessible components
     *      when JAWS accessible feature(508) is used.
     *  Created by: jtorreno
     *  Date: 2008.02.08
     *
     **/
    public static function accessComponentDescription(
            component:UIComponent, accessName:String): void
    {

        if ((component != null) && (accessName != null)) {
            component.accessibilityProperties =
            new AccessibilityProperties();
            component.accessibilityProperties.description = accessName;

            setTimeout(updateAccessibleProperties, ACC_READ_DELAY);
        }

    }

    /**
     *  Function: accessAppViewHeader()
     *  Parameters:
     *      component:UIComponent - Screen component reference
     *      tabIndex:int - Tab index to be read by JAWS
     *  Description:
     *      Reads application header when JAWS accessible
     *      feature(508) is used.
     *  Created by: jtorreno
     *  Date: 2008.02.12
     *
     **/
    public static function accessAppViewHeader(component:UIComponent,
                                               tabIndex:int):void
    {

        if ((component != null) && (tabIndex >= 0)) {
            component.accessibilityProperties =
            new AccessibilityProperties();
            component.focusEnabled = true;
            component.tabIndex = tabIndex;

            setTimeout(updateAccessibleProperties, ACC_READ_DELAY);                            
        }

    }

    /**
     *  Function: isAccessibilityToolActive()
     *  Parameters:
     *        NONE
     *  Description:
     *      Checks if accessibility tool is active.
     *  Return:
     *      Returns false if JAWS reader is active
     *  Created by: jtorreno
     *  Date: 2008.04.1
     *
     **/
    public static function setToFalseIfAccessToolIsActive():Boolean
    {
        var bActive:Boolean = true;

        if (isAccessibilityActive()) {
            bActive = false;
        }
        return bActive;
    }

    public static function isAccessibilityActive():Boolean
    {
//        return true;
                      return Accessibility.active;
    }
}
}