package gov.va.med.edp.pt.demog.control {
import gov.va.med.edp.pt.demog.IPatientChecksDao;
import gov.va.med.edp.pt.demog.model.PatientChecksModel;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import gov.va.med.edp.pt.demog.IPatientChecksController;

/**
 * Manage patient checks.
 * 
 *
 */	
public class PatientChecksController implements IPatientChecksController {

    [Bindable]
    public var model:PatientChecksModel;

    [Bindable]
    public var dao:IPatientChecksDao;

	/**
	 *   Constructor.
	 */
	public function PatientChecksController() 
	{
	}
	
	/**
	 * Reset the model.
	 * 
	 *
	 */	
    public function resetPatientChecks():void {
       model.reset();
    }

	/**
	 * Load the patient check environment
	 * 
	 * @param pt
	 * @param forwardOnLoad
	 * 
	 */
    public function loadPatientChecks(pt:PatientSelectVO, forwardOnLoad:Boolean = false):void {
        resetPatientChecks();
        model.checkState = PatientChecksModel.STATE_LOADING;
        dao.loadPatientChecks(new CheckSensitivePtAndFlagsResponder(this, model, pt, forwardOnLoad), pt);
    }
	
/**
 * Log patient check environment
 * 
 * @param pt
 * 
 */
    public function logPatientAccess(pt:PatientSelectVO):void {
        logAccessForDfn(pt.dfn);
    }


    private function logAccessForDfn(dfn:String):void {
        dao.logPatientAccess(new LogSensitivePatientAccessResponder(), dfn);
    }

	/**
	 * Enable back click 
	 * 
	 * 
	 */
    public function backPatientCheck():void {
        model.back();
    }

	/**
	 * Enable forward patient checks
	 * 
	 * 
	 */
    public function forwardPatientCheck():void {     
        if (model.continueEnabled && model.checkState == PatientChecksModel.STATE_SENSITIVE && model.patientChecks.logAccess) {
           logAccessForDfn(model.patientChecks.dfn); 
        }
        model.forward();
    }
}
}