package gov.va.med.edp.pt.demog.control {

import gov.va.med.edp.pt.demog.IMatchPatientsController;
import gov.va.med.edp.business.MatchPatientsDelegate;
import gov.va.med.edp.pt.demog.model.MatchingPatientsModel;

/**
 * Controller to handle match patients functionality.
 * 
 *
 */	
public class MatchPatientsController implements IMatchPatientsController {

    [Bindable]
    public var model:MatchingPatientsModel;

	/**
	 *   Constructor.
	 */
	public function MatchPatientsController() 
	{
	}
	/**
	 *  Reset the matching patients
	 */
    public function resetMatchingPatients():void {
        model.matchingPatients = null; // TODO: is this right?
        model.matchingPatientsLoaded = false;
        model.matchingPatientsTruncated = false;
    }
	/**
	 *   matching patients
	 */
    public function matchPatients(partial:String):void {
        model.matchingPatientsLoaded = false;

        if ((partial == null) || (partial.length == 0)) {
            model.matchingPatients = null;
            return;
        }

        var delegate:MatchPatientsDelegate = new MatchPatientsDelegate(new MatchPatientsResponder(model));
        delegate.matchPatients(partial);
    }
}
}