package gov.va.med.edp.model.worksheet
{
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.vo.worksheet.ComponentVO;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	
	import mx.binding.utils.BindingUtils;
	import mx.collections.ArrayCollection;
	import mx.containers.FormItem;
	/**
	 * Class representation of a Section that resides within a worksheet.
	 * @author useruseruser12
	 * 
	 */
	public class SectionModel implements ISection
	{
		[Bindable]
		private var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		private var summary:Array = [];				
		private var _sectionVO:SectionVO;
		/** 
		 * The ArrayCollection of Sections. 
		 */
		[Bindable]
		public var formItemsArrayCollection: ArrayCollection = new ArrayCollection();		
		/**
		 * Constructor.
		 */
		public function SectionModel()
		{
			//TODO: implement function
		}
		
		/**
		 * 
		 */
		public function getComponentArray():Array
		{
			return _sectionVO.componentVOArray;
		}

		public function getSectionVO():SectionVO
		{
			return _sectionVO;
		}

		public function setSectionVO(value:SectionVO):void
		{
			_sectionVO = value;
		}

		public function setFormItems(fields:ArrayCollection):void
		{
			formItemsArrayCollection = fields;
		}
		
		public function getFormItems():ArrayCollection
		{
			return formItemsArrayCollection;
		}
		
		/**
		 * 
		 * @param section
		 * @return 
		 * 
		 */
		public function addFormItems(formItem:FormItem):void
		{
			//TODO: Check for duplicates.
			formItemsArrayCollection.addItem(formItem);
		}
		
		public function summarize():String
		{
			
			var components:Array = getComponentArray();// Already sorted
			
			var componentVO:ComponentVO;
			var length:int = components.length;
			var componentsInSummaryLength:int;
			
			var sortedComponentsInSummary:ArrayCollection = new ArrayCollection();
			var componentsInSummary:ArrayCollection = new ArrayCollection();
			
			var index:int = 0;
			var i:int = 0;			
			var x:int = 0;
			
			trace("Component Summary In Size " + length);
			
			for (i; i < length; i++) 
			{
				componentVO = components[i] as ComponentVO;
				
				if(Boolean(componentVO.includeInSummary))
				{
					
					var summaryLabel:String = new String();
					
					summaryLabel = componentVO.summaryLabel + ":" ;
					
					//BindingUtils.bindProperty(uiComponentLabel, 'text', model, getPropertyChainFromValue(componentVO.value));
					//componentsInSummary.addItemAt(componentVO.summaryLabel + ":",i);
					
					add(componentVO.summaryLabel + ":");
					
				}			
			}
	
			
			//return sorted.source;
			return getSummary();
		}
		
		public function expand():void
		{
			//TODO: implement function
		}
		
		public function contract():void
		{
			//TODO: implement function
		}
		
		
		/**
		 * Returns the string representation of this object.
		 * @return String - The string representation of this object
		 * 
		 */
		public function toString():String
		{
			// TODO Auto Generated method stub
			return super.toString();
		}
				
		public function add(str:String):void
		{
			for (var i:Number = 0; i < str.length; i++)
			{
				summary.push(str.charCodeAt(i));
			}
		}
		
		public function getSummary():String
		{
			return String.fromCharCode.apply(this, summary);
		}
		
		private function getPropertyChainFromValue(val:String):Array
		{			
			var propertyChain:Array = new Array();			
			var delimiter:String = ".";			
			
			if (val != null && val.length > 0) 
			{							
				propertyChain = val.split(delimiter);		 				
			}
			
			return propertyChain;			
		}
		
	}
}