package gov.va.med.edp.model.worksheet
{
	import mx.collections.ArrayCollection;	
	/**
	 * Interface for worksheet containers. 
	 * 
	 * @author useruseruser12
	 * 
	 */
	public interface IWorkSheet
	{		
		/**
		 * Sets the sections for this worksheet.
		 * @param sections The ArrayCollection of Sections.
		 */
		function setSections(sections:ArrayCollection /* of Section */): void;
		/**
		 * Returns the sections for this worksheet.
		 * @return The ArrayCollection of Sections.
		 */
		function getSections(): ArrayCollection /* of Section */;
		/**
		 * Summarizes the content of all the sections within this worksheet.
		 * @return This summarized aggregate section string.
		 */
		function summarize(): String;
		
		/**
		 * 
		 * @return 
		 * 
		 */
		function getName():String;		
		/**
		 * 
		 * @param value
		 * @return 
		 * 
		 */
		function setName(value:String): void;
	}
}