package gov.va.med.edp.model.worksheet
{
	import mx.collections.ArrayCollection;	
	/**
	 * Interface for sections within worksheets. 
	 * @author useruseruser12
	 */
	public interface ISection
	{		
		/**
		 * Sets the fields for this section.
		 * @param fields The ArrayCollection of FormItems.
		 */
		function setFormItems(fields:ArrayCollection /* of FormItem */): void;
		/**
		 * Returns the fields for this section.
		 * @return The ArrayCollection of FormItems.
		 */
		function getFormItems(): ArrayCollection /* of FormItem */;		
		/**
		 * Summarizes the content of this section.
		 * @return This summarized section string.
		 */
		function summarize(): String;		
		/**
		 * Expands this section.
		 */
		function expand(): void;		
		/**
		 * Contracts this section.
		 */
		function contract(): void;
		
		/**
		 * 
		 */
		function getComponentArray():Array;
		
		///**
		// * @private
		// */
		//function setComponentArray(value:Array):void;
		
	}
}