package gov.va.med.edp.model.worksheet
{
	import gov.va.med.edp.vo.worksheet.AbstractWorkSheetVO;
	
	import mx.collections.ArrayCollection;
	
	/**
	 * Abstract base class for worksheets.  The implementing concrete classes
	 * can either be a Worksheet or a Report.
	 * 
	 * @author useruseruser12
	 * 
	 */
	public class AbstractWorksheetModel implements IWorkSheet
	{
		
		protected var _abstractWorkSheetVO:AbstractWorkSheetVO;
		
		/** 
		 * The ArrayCollection of Sections. 
		 */
		[Bindable]
		public var sectionsArrayCollection: ArrayCollection = new ArrayCollection();
		
		/**
		 * Constructor.
		 */		
		public function AbstractWorksheetModel()
		{
			//TODO: implement function
		}
		
		public function setSections(sections:ArrayCollection):void
		{
			sectionsArrayCollection = sections;
		}
		
		public function getSections():ArrayCollection
		{
			return sectionsArrayCollection;
		}
		
		/**
		 * 
		 * @param section
		 * @return 
		 * 
		 */
		public function addSection(section:SectionModel):void
		{
			//TODO: Check for duplicates.
			sectionsArrayCollection.addItem(section);
		}
		
		/**
		 * 
		 *  
		 */
		public function clearSections():void
		{
			sectionsArrayCollection.removeAll();
		}
		
		public function summarize():String
		{
			//TODO: implement function
			return null;
		}
						
		/**
		 * Returns the string representation of this object.
		 * @return String - The string representation of this object
		 * 
		 */
		public function toString():String
		{
			// TODO Auto Generated method stub
			//return super.toString();
			return getName();
		}

		public function getAbstractWorkSheetVO():AbstractWorkSheetVO
		{
			return _abstractWorkSheetVO;
		}

		public function setAbstractWorkSheetVO(value:AbstractWorkSheetVO):void
		{
			_abstractWorkSheetVO = value;
		}
		
		public function getName():String
		{
			return _abstractWorkSheetVO.name;
		}
		
		public function setName(value:String):void
		{
			_abstractWorkSheetVO.name = value;
		}

	}
}