package gov.va.med.edp.model.reports
{
	

	[Bindable]
	/**
	 * This class defines all of the reports available in EDIS
	 */
	public class ReportsModel
	{
		import gov.va.med.edp.model.reports.*;
			
		public var reportType: String = "";
		public var clearDisplayArea: Boolean = false;
		public var startDate: Date;
		public var stopDate: Date;
		public var resident: String;
		public var patient: String;
		
		public var activityReport: ActivityReport = new ActivityReport();
		public var acuityReport: AcuityReport = new AcuityReport();
		public var delayReport: DelayReport = new DelayReport();
		public var summaryReport: SummaryReport = new SummaryReport();
		public var shiftReport: ShiftReport = new ShiftReport();
		public var missedOpReport: MissedOpReport = new MissedOpReport();
		public var patientXRefReport: PatientXRefReport = new PatientXRefReport();
		public var vaAdmissionsReport: VaAdmissionsReport = new VaAdmissionsReport();
		public var providerReport: ProviderReport = new ProviderReport();
		public var ptIntakeReport: PtIntakeReport = new PtIntakeReport();
		public var exposureReport: ExposureReport = new ExposureReport();
		public var bvacReport: BVACReport = new BVACReport();
		public var ordersByAcuityReport: OrdersByAcuityReport = new OrdersByAcuityReport();
		public var patientsRemovedInErrorReport: PatientsRemovedInErrorReport = new PatientsRemovedInErrorReport();
		public var customReportRpt: CustomReportRpt = new CustomReportRpt();
		
		/**
		 *   Constructor.
		 */
		public function ReportsModel() 
		{
		}
		
	}

}