/* TrackingModelLocator.as */

package gov.va.med.edp.model
{
import com.adobe.cairngorm.control.CairngormEventDispatcher;
import com.adobe.cairngorm.model.ModelLocator;

import flash.events.Event;
import flash.events.TimerEvent;
import flash.net.URLRequest;
import flash.net.navigateToURL;
import flash.utils.Timer;

import gov.va.med.edp.control.DetailsEvent;
import gov.va.med.edp.control.DisplayBoardEvent;
import gov.va.med.edp.control.GetVitalsEvent;
import gov.va.med.edp.control.LabTrendEvent;
import gov.va.med.edp.control.TimerControlEvent;
import gov.va.med.edp.control.reports.adhoc.ReportChangedEvent;
import gov.va.med.edp.control.worksheet.WorkSheetStatusEvent;
import gov.va.med.edp.control.worksheet.WorkSheetWidgetEvent;
import gov.va.med.edp.model.reports.*;
import gov.va.med.edp.model.worksheet.WorkSheetModel;
import gov.va.med.edp.pt.demog.model.PatientChecksModel;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import gov.va.med.edp.view.worksheet.WorkSheetPanel;
import gov.va.med.edp.vo.ComplaintDetailsVO;
import gov.va.med.edp.vo.LogEditParamsVO;
import gov.va.med.edp.vo.LogSelectorVO;
import gov.va.med.edp.vo.SessionVO;
import gov.va.med.edp.vo.StaffMemberVO;
import gov.va.med.edp.vo.VisitVO;
import gov.va.med.edp.vo.VitalsVO;
import gov.va.med.edp.vo.reports.PtDemographicsVO;
import gov.va.med.edp.vo.reports.adhoc.AdhocReportSearchParametersVO;
import gov.va.med.edp.vo.reports.adhoc.AdhocReportVO;
import gov.va.med.edp.vo.worksheet.WorkSheetListVO;

import mx.collections.ArrayCollection;
import mx.collections.XMLListCollection;
import mx.containers.ViewStack;
import mx.controls.Alert;
import mx.rpc.Fault;


[Bindable]
/**
 * The Base Model that holds all data for this EDIS session
 */
public class TrackingModelLocator implements ModelLocator
{
	// Possible view states for the application
	public static const VIEW_APP_INTRO: int = 0;
	public static const VIEW_APP_SIGN_IN: int = 1;
	public static const VIEW_APP_TRIAGE: int = 2;
	public static const VIEW_APP_UPDATE: int = 3;
	public static const VIEW_APP_DISPOSITION: int = 4;
	public static const VIEW_APP_EDIT_CLOSED: int = 5;
	public static const VIEW_APP_DISPLAY_BOARD: int = 6;
	public static const VIEW_APP_ASSIGN_STAFF: int = 7;
	public static const VIEW_APP_REPORTS: int = 8;
	public static const VIEW_APP_CONFIGURE: int = 9;
	public static const VIEW_APP_VERSION_INCOMPATIBILITY: int = 90;
	public static const VIEW_APP_NO_VIEWS: int = 99;
	
	/**
	 *  Here are the new attributes for the CPE Environment.
	 */
	public static const VIEW_APP_INTRO_CPE: int = 200;
	public static const VIEW_APP_CPE: int = 201;
	public static const VIEW_APP_CONFIG_CPE: int = 202;
	public static const VIEW_APP_SPLIT_VIEW: int = 203;
	//public static const VIEW_APP_EDIT_CLOSED_CPE: int = 203;


	public static const VIEW_EDIT_MESSAGE: String = "Message";
	public static const VIEW_EDIT_SIGN_IN: String = "SignIn";
	public static const VIEW_EDIT_TRIAGE: String = "Triage";
	public static const VIEW_EDIT_UPDATE: String = "Update";
	public static const VIEW_EDIT_UPDATE_NORES: String = "UpdateNoRes";
	public static const VIEW_EDIT_DISP_DELAY: String = "DispDelay";
	public static const VIEW_EDIT_DISP_DELAY_CODED: String = "DispDelayCoded";
	public static const VIEW_EDIT_CLOSED: String = "EditClosed";
	public static const VIEW_EDIT_CLOSED_CODED: String = "EditClosedCoded";
	public static const VIEW_EDIT_DISPLAY_BOARD: String = "DisplayBoard";

	/**
	 * CPE save states.
	 */
	public static const VIEW_EDIT_SAVE_CANCEL_CAPABLE: String = "SaveCancelCapable";
	public static const VIEW_EDIT_REMOVE_CAPABLE: String = "RemoveCapable";
	public static const VIEW_EDIT_RESTORE_CAPABLE: String = "RestoreCapable";
	/**
	 * EDIS Footer views.
	 */
	public static const VIEW_BUTTON_PANEL: String = "SavePanelView";
	public static const VIEW_MESSAGE_PANEL: String = "MessagePanelView";
	public static const VIEW_SHOW_FOOTER: String = "ShowFooter";
	public static const VIEW_HIDE_FOOTER: String = "HideFooter";
	/**
	 * CPE view states.
	 */
	public static const VIEW_EDIT_SPLIT_VIEW: String = "SplitView";
	public static const VIEW_EDIT_PATIENT_VIEW: String = "PatientView";
	public static const VIEW_EDIT_BOARD_VIEW: String = "BoardView";
	
	public static const APP_NAME_BIGBOARD: String = "bigboard";
	public static const APP_NAME_TRACKING: String = "tracking";
	
	public var bigboardInfo: BigBoardDebugInfo;

	public var appName: String = "";

	public var appClientVersion: String = "2.1.1";

	public var contextRoot: String = "";
	public var appViewList: ArrayCollection = new ArrayCollection();
	
	public var appViewState: int = VIEW_APP_INTRO_CPE;
	public var logEntryViewState: String = "";
	public var logEntryTitle: String = "";

	// Session information
	public var session: SessionVO;
	public var rootURL: String;
	public var logoutURL: String;
	public var helpContextRootURL: String;
	
	// Reports
	public var reports: ReportsModel = new ReportsModel();

	// Debug
	public var debug: DebugModel = new DebugModel();

	// Log Editor
	public var logArea: int;
	public var logEntryList: LogEntryList = new LogEntryList();
	public var logEdit: LogEdit = new LogEdit();
	public var logEditParams: LogEditParamsVO = new LogEditParamsVO();
	public var matchingDiagnoses: ArrayCollection;
	public var matchingDiagnosesLoaded: Boolean = false;

	// Patient Selection
	public var patientChecksModel:PatientChecksModel = new PatientChecksModel();

	public var matchingClosedVisits: ArrayCollection;
	public var matchingClosedVisitsIndex: int = -1;
	public var matchingClosedFinished: Boolean = false;
	public var matchingClosedPatientSelected: Boolean = false;

	// Display Board
	public var boardSortField: String = "";
	public var boardSortDescending: Boolean;
	public var boardReady: Boolean = false;
	public var boardData: XMLListCollection = new XMLListCollection(); 
	public var boardSpec: BoardSpec = new BoardSpec();
	public var boardLastUpdated: Date;
	public var textUpdated:Boolean = false;

	// Configure
	public var config: Config = new Config();

	// Connectivity
	public var reconnectFunction:Function;
	public var disconnectionFault:Fault = null;
	private var _disconnected: Boolean = false;
	private var _connecting: Boolean = false;
	private var _reconnectTimer: Timer;
	
	// Labs
	public var labVOList:ArrayCollection = new ArrayCollection();
	public var labsWanted:ArrayCollection;
	public var priorLabsInterval:int = 6;  //  prior labs week interval to search (6 weeks)
	public var totalLabsToRequest:int = 50; // Default amount to be called per request
	public var currentLabCount:int = 0; // Default amount to be called per request
	public var testIds:ArrayCollection = new ArrayCollection();
	public var labsComplete: Boolean = false;	
	/**
	 * MicroBiology list.
	 */
	public var microbiologyVOList:ArrayCollection = new ArrayCollection();
	/**
	 * Radiology list.
	 */
	public var radiologyVOList:ArrayCollection = new ArrayCollection();
	/**
	 * Contains vitals information and logic.
	 */
	public var vitalsModel:VitalsModel = new VitalsModel();
	public var vitalsSaved:Boolean = false;
	public var vitalsVO:VitalsVO= new VitalsVO()
			
	// Demog
	public var demog:PtDemographicsVO;
	public var demogWanted:int;
	public var demogList:ArrayCollection = new ArrayCollection();
	public var demogReady:Boolean;

	// Active Meds
	public var activeMeds:ArrayCollection = new ArrayCollection();
	// Active Problems
	public var activeProblems:ArrayCollection = new ArrayCollection();

	
	// Complaints
	public var complaint:ComplaintDetailsVO;
	
	public var reloadFunction:Function; // function for reloading the flash application in case of fatal error or sommat

	private static const RECONNECT_SECONDS:int = 10;
	
	//Worksheet
	public var worksheetViewState: String = "";
	
	public var displayVisitWorksheet:Boolean = false;
	public var displayVisitSummary:Boolean = false;
	public var activateTriageMode:Boolean = false;
	
	//Refresh
	public var rowSelected:Number = -1;
	public var logIndex:int = 0;
	public var logID:Number = 0;
	public var topIndex:int;
	public var refreshReady:Boolean = false;
	public var refreshTimer:Timer;
	
	//Reset
	public var unselectBoard:Boolean = false;
	
	public var appFooterViewState: String = VIEW_MESSAGE_PANEL;	
	public var appFooterVisibilityState: String = "";

	/**
	 * CPE Related artifacts
	 */
	public var boardShowing: Boolean = true;
	public var boardSplit: Boolean = false;
	public var splitMode: Boolean = false;		
	public var showPushPin: Boolean = false;
	public var showWorksheetToggleButtonBar: Boolean = false;
	public var patientViews:ViewStack;
	
	/**
	 * Worksheet related artifacts.
	 */
	public var workSheetModels:ArrayCollection = new ArrayCollection();
	public var workSheetLoaded:Boolean = false;
	public var workSheetViews:ViewStack;
	public var roles: XMLList;
	public var roleSelected:String;
	public var roleWorksheets: ArrayCollection;
	public var roleWorksheetLoaded:Boolean = false;
	public var worksheetArtifacts:XMLList;
	public var worksheetSelected:Boolean = false;
	public var workSheetList: ArrayCollection = new ArrayCollection();
	public var sectionList: XMLList;
	public var componentList: XMLList;
	public var populatedComponentList: ArrayCollection = new ArrayCollection();
	public var artifactsLoaded:Boolean = false;
	private var worksheetModelAddedEvent:WorkSheetStatusEvent;
	public var validators: Array = [];
	public var worksheetNameToWorksheet:Object = new Object();
	public var worksheetNameToModel:Object = new Object();
	public var isEditClosed:Boolean = true;
	/**
	 * This is the list of required worksheets for the app to work.
	 */
	public var requiredWorksheets:Array = new Array("Visit", "Edit Closed");
	private var requiredWorksheetsCollection:ArrayCollection = new ArrayCollection();
	private var requiredWorksheetsIndex:int = 0;
	public var defaultRequiredWorksheet:String = "Visit";
	public var editClosedWorksheet:String = "Edit Closed";
	/**
	 * Adhoc report related artifacts 
	 */
	public var adhocReportList: ArrayCollection = new ArrayCollection();
	public var currentAdhocReportRoleList: ArrayCollection = new ArrayCollection();
	public var currentAdhocReportElementList: ArrayCollection = new ArrayCollection();
	public var currentAdhocReport:AdhocReportVO;
	
	public var reportElementsLoaded:Boolean = false;
	public var reportElements:ArrayCollection;
	
	public var reportSearchPatientLoaded:Boolean = false;
	public var reportSearchPatient:PatientSelectVO;
	
	public var reportSearchStaffLoaded:Boolean = false;
	public var reportSearchStaff:StaffMemberVO;
	public var reportStaffLoaded:Boolean = false;
	public var reportStaff:ArrayCollection;
	
	public var adhocReportHeaders:ArrayCollection;
	public var adhocReportContent:XMLList;
	
	public var adhocReportSearchParameters:AdhocReportSearchParametersVO = new AdhocReportSearchParametersVO();
	public var adhocDirty:Boolean = false;
	
	public var boardTimerStopped:Boolean = false;
	
	public var logEditMessageFontSize:int = 10;
	
	public var isNew: Boolean = false;
	
	//Singleton logic -----------------------------------------------------------

	private static var modelLocator: TrackingModelLocator;

	public static function getInstance(): TrackingModelLocator
	{
		if (modelLocator == null) {
			modelLocator = new TrackingModelLocator();
		}
		return modelLocator;
	}

	public function TrackingModelLocator()
	{
		if (modelLocator != null) {
			throw new Error("Only one TrackingModelLocator should be instantiated.");
		}
		
		registerListeners();
		initEvents();
		initRequiredWorksheetCollection();
		initTimer();
	}
	
	private function initTimer():void
	{
		refreshTimer = new Timer(30000);
		refreshTimer.addEventListener(TimerEvent.TIMER, refreshDisplayBoard);
	}
	
	private function refreshDisplayBoard(event: TimerEvent): void
	{

//		var now:Date = new Date();
//		Alert.show("refresh... "+now);
//		trace("refresh... "+now);
		if (this.session.area < 1) return;
		var refreshEvent: DisplayBoardEvent =
			new DisplayBoardEvent(DisplayBoardEvent.EVENT_REFRESH_DISPLAY_BOARD);
		refreshEvent.dispatch();
		
	}
	
	private function initRequiredWorksheetCollection(): void {
		for each (var name:String in requiredWorksheets) {
			requiredWorksheetsCollection.addItem(name);
		}
	}
	

	public function isDisconnected(): Boolean {
		return disconnected;
	}

	public function buildSiteDate(): Date
	{
		var now:Date = new Date();
		return new Date(now.time - session.baseTime.time + session.siteTime.time);
	}

	public function synchToLastEntry(): void
	{
		for (var i:int = 0; i < logEntryList.entries.length; i++) {
			var logSelector: LogSelectorVO = logEntryList.entries[i];
			if (logSelector.id == logEdit.entry.id) {
				logEntryList.selectedIndex = -1;  // force binding to fire
				logEntryList.selectedIndex = i;
				logEntryList.selectedID = logSelector.id;
				return;
			} // if
		} // for
	} // synchToLastEntry

	public function synchToClosedEntry(): void
	{
		for (var i: int = 0; i < matchingClosedVisits.length; i++) {
			var visit: VisitVO = matchingClosedVisits[i];
			if (visit.id == logEdit.entry.id) {
				matchingClosedVisitsIndex = -1;  // force binding to fire
				matchingClosedVisitsIndex = i;
				return;
			} // if
		} // for
	} // synchToClosedEntry

	public function appViewTitle(view: int): String
	{
		switch (appViewState) {
			case VIEW_APP_SIGN_IN:
				return "EDIS Sign In";
			case VIEW_APP_TRIAGE:
				return "EDIS Triage";
			case VIEW_APP_UPDATE:
				return "EDIS Update";
			case VIEW_APP_DISPOSITION:
				return "EDIS Disposition";
			case VIEW_APP_EDIT_CLOSED:
				return "EDIS Edit Closed Visit";
			case VIEW_APP_DISPLAY_BOARD:
				return "EDIS Display Board";
			case VIEW_APP_ASSIGN_STAFF:
				return "EDIS Staff List";
			case VIEW_APP_REPORTS:
				return "EDIS Reports";
			case VIEW_APP_CONFIGURE:
				return "EDIS Configuration";
			case VIEW_APP_NO_VIEWS:
				return "EDIS Home";
			case VIEW_APP_CPE:
				return "EDIS CPE";
			default:
				return "EDIS Home";
		}
	}

	public function appViewHelp(view: int): String
	{
		switch (appViewState) {
			case VIEW_APP_SIGN_IN:
				return "SignIn";
			case VIEW_APP_TRIAGE:
				return "Triage";
			case VIEW_APP_UPDATE:
				return "Update";
			case VIEW_APP_DISPOSITION:
				return "Disposition";
			case VIEW_APP_EDIT_CLOSED:
				return "EditClosedVisit";
			case VIEW_APP_DISPLAY_BOARD:
				return "DisplayBoard";
			case VIEW_APP_ASSIGN_STAFF:
				return "StaffList";
			case VIEW_APP_REPORTS:
				return "Reports";
			case VIEW_APP_CONFIGURE:
				return "Configuration";
			case VIEW_APP_NO_VIEWS:
				return "index";
			case VIEW_APP_CPE:
				return "CPE_View";
			default:
				return "index";
		}
	}
	
	public function setWorksheetState (state:String): void
	{		
		//This will trigger an update.
		
		worksheetViewState = state;			
	}
	
	public function evaluateFooterState(): void
	{		
		if((splitMode || !boardShowing)
			&& isFooterApplicableForView())
		{						
			this.appFooterVisibilityState = TrackingModelLocator.VIEW_SHOW_FOOTER;
			
		} else {

			this.appFooterVisibilityState = TrackingModelLocator.VIEW_HIDE_FOOTER	

		}			
	}
	
	private function isFooterApplicableForView(): Boolean
	{
		return ((appViewState == TrackingModelLocator.VIEW_APP_CPE)
			|| (appViewState == TrackingModelLocator.VIEW_APP_EDIT_CLOSED));
	}
	
	public function setEditState(): void
	{
		// convenient place to clear lookup list since this is called when entry changes
		matchingDiagnoses = null;
		trace("TML.setEditState " + appViewState);
		switch (appViewState) {
			case VIEW_APP_EDIT_CLOSED:
				logEditParams.codedDiagnosis ?
				logEntryViewState = VIEW_EDIT_CLOSED_CODED :
				logEntryViewState = VIEW_EDIT_CLOSED;
				break;
			case VIEW_APP_DISPLAY_BOARD:
				logEntryViewState = VIEW_EDIT_DISPLAY_BOARD;
				break;
			case VIEW_APP_CPE:
				logEntryViewState = VIEW_EDIT_BOARD_VIEW; // DEFAULT TO BOARD VIEW
				break;
			default:
				logEntryViewState = "";
				break;
		} // switch
				
		evaluateFooterState();
		
	} // setEditState
	
	public function modifiedViews(): String
	{
		var x: String = "";
		if (logEdit.dirty) {
			var viewName: String = logEntryViewState;
			viewName = (viewName.substr(0, 4) == "Disp") ? "Disposition" : viewName;
			viewName = (viewName.substr(0, 4) == "Upda") ? "Update" : viewName;
			viewName = (viewName.substr(0, 4) == "Edit") ? "Edit Closed" : viewName;
			x += "\t" + viewName + "\n";
		}
		x += config.staffMods ? "\tStaff Configuration \n" : "";
		x += config.bedMods ? "\tRoom / Bed Configuration \n" : "";
		x += config.boardMods ? "\tDisplay Board Configuration \n" : "";
		x += config.colorMods ? "\tColor Configuration \n" : "";
		x += config.paramMods ? "\tParameter Configuration \n" : "";
		x += config.selectionMods ? "\tSelection List Configuration \n" : "";
		return x;
	}


	public function entryRemoveReady(): void
	{
		
		var ready: Boolean = true;
		
		if (logEdit.entry.closed) {
			logEdit.entry.restoreReady = true;
			ready = false;
			return;
		} else {
			logEdit.entry.restoreReady = false;
		}
		
		// special dispositions that allow immediate removal
		if ((logEdit.entry.disposition == logEditParams.errorIEN) ||
			(logEdit.entry.disposition == logEditParams.nurseEvalIEN) ||
			(logEdit.entry.disposition == logEditParams.leftIEN)) {
			logEdit.entry.removeReady = true;						
			return;
		}

		if (logEdit.entry.requireDiagnosis && (logEdit.entry.diagnoses.length == 0)) {
			ready = false;
		}
		if (logEdit.entry.requireDisposition &&
			((logEdit.entry.disposition == logEditParams.emptyValue) ||
			 (logEdit.entry.disposition < 1))) {
			ready = false;
		}
		if (logEdit.entry.requireDelay &&
			((logEdit.entry.delay == logEditParams.emptyValue) ||
			 (logEdit.entry.delay < 1))) {
			ready = false;
		}
		if (Number(logEdit.entry.provider) < 1) {
			ready = false;
		}
				
		logEdit.entry.removeReady = ready;
	}

	public function logout(): void {
		var request: URLRequest = new URLRequest(logoutURL);
		navigateToURL(request, "_top");
	}

	public function get disconnected(): Boolean {
		return _disconnected;
	}

	public function set disconnected(b:Boolean):void {
		if (_disconnected && !b) {
			stopReconnectCountdown();
			disconnectionFault = null;
		} else if (!_disconnected && b) {
			startReconnectCountdown();
		}
		_disconnected = b;
	}

	public function get connecting(): Boolean {
		return _connecting;
	}

	public function set connecting(b:Boolean):void {
		_connecting = b;
		if (disconnected) {
			if (!_connecting) {
				startReconnectCountdown();
			} else {
				stopReconnectCountdown();
			}
		}
	}

	[Bindable(event="reconnectSecondsChanged")]
	public function get reconnectSeconds():int {
		if (_reconnectTimer == null) return RECONNECT_SECONDS;
		return _reconnectTimer.repeatCount - _reconnectTimer.currentCount;
	}

	public function attemptReconnect():void {
		stopReconnectCountdown();
		if(reconnectFunction != null) {
			reconnectFunction.call(null);
		}
	}

	private function reconnectCountDown(e:TimerEvent):void {
//		dispatchEvent(new Event("reconnectSecondsChanged"));
	}

	private function reconnectTimerComplete(e:TimerEvent):void {
		attemptReconnect();
	}

	private function startReconnectCountdown():void {
		if (_reconnectTimer == null) {
			_reconnectTimer = new Timer(1000, RECONNECT_SECONDS);
			_reconnectTimer.addEventListener(TimerEvent.TIMER, reconnectCountDown);
			_reconnectTimer.addEventListener(TimerEvent.TIMER_COMPLETE, reconnectTimerComplete);
		}
		_reconnectTimer.reset();
		_reconnectTimer.start();
	}

	private function stopReconnectCountdown():void {
		if (_reconnectTimer != null) {
			_reconnectTimer.reset();
		}
	}
	
	public function getNextRequiredWorksheet() : WorkSheetListVO
	{
		var workSheetListVO:WorkSheetListVO;
		
		
		if(requiredWorksheetsIndex == requiredWorksheetsCollection.length) {
			return null;
		}
		
		var worksheetName:String = String(requiredWorksheetsCollection.getItemAt(requiredWorksheetsIndex));
		
		for each (var ws:WorkSheetListVO in workSheetList) {
			
			if(ws.worksheetName == worksheetName) {
				workSheetListVO = ws;
				trace("Worksheet " + workSheetListVO);
				requiredWorksheetsIndex++;
				break;
			}
		}
		
		
		return workSheetListVO;
	}
	
	public function getNextIds() : String
	{	
		var tIds:String = ""; // 489^141
		var delim:String = "^";
				
		var labsToRequest:int = 0;
		
		var testIdLength:int = testIds.length;
		
		if (testIdLength < totalLabsToRequest) 
		{
			labsToRequest = testIdLength;
			
		} else {
			
			labsToRequest = totalLabsToRequest;
			
		}
		
		var total:int = labsToRequest + currentLabCount;
			
		
		for (var i:int = currentLabCount; i < total; i++) 
		{
			
			if(testIdLength == i) {
				labsComplete = true;
				break;
			}
			
			tIds = tIds + testIds.getItemAt(i) + delim;
			
		}
		

		tIds = tIds.substring(0, tIds.length-1);
		currentLabCount = total;
		
		return tIds;
	} 
	
	public function resetLabData(clearList:Boolean = true) : void
	{
		labsComplete = false;
		testIds.removeAll();
		currentLabCount = 0;
		if(clearList)
		{
			labVOList.removeAll();
		}
	}
	
	public function isEditClosedView(): Boolean
	{
		if(logEntryViewState == VIEW_EDIT_CLOSED_CODED 
			|| (logEntryViewState == VIEW_EDIT_CLOSED)) {
			
			return true;									
			
		}					
		
		return false;
	}
	
	private function registerListeners():void
	{
		CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.RESET,handleWidgetStateChange);
		CairngormEventDispatcher.getInstance().addEventListener(WorkSheetWidgetEvent.ERROR,handleWidgetStateChange);
		
		CairngormEventDispatcher.getInstance().addEventListener( 
			ReportChangedEvent.EVENT_ADHOC_REPORT_ELEMENTS_CHANGE, handleReportChange );
		
		CairngormEventDispatcher.getInstance().addEventListener( 
			ReportChangedEvent.EVENT_ADHOC_REPORT_NAME_CHANGE, handleReportChange );
		
		CairngormEventDispatcher.getInstance().addEventListener( 
			ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_PATIENT_CHANGE, handleReportChange );
		
		CairngormEventDispatcher.getInstance().addEventListener( 
			ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_RESIDENT_CHANGE, handleReportChange );
		
		CairngormEventDispatcher.getInstance().addEventListener( 
			ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_START_DATE_CHANGE, handleReportChange );
		
		CairngormEventDispatcher.getInstance().addEventListener( 
			ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_STOP_DATE_CHANGE, handleReportChange );
		
		CairngormEventDispatcher.getInstance().addEventListener(
			TimerControlEvent.START_TIMER, handleStartTimer);
		
		CairngormEventDispatcher.getInstance().addEventListener(
			TimerControlEvent.STOP_TIMER, handleStopTimer);
	
	}
	
	private function handleStartTimer(event:TimerControlEvent) :void
	{
		if (!refreshTimer.running) {
			trace("*********  turning on!");
			refreshTimer.start();
		}
	}
	
	private function handleStopTimer(event:TimerControlEvent) :void
	{
		if (refreshTimer.running) {
			trace("*********  turning off!");
			refreshTimer.stop();
		}
	}
	
	protected function initEvents():void
	{
		worksheetModelAddedEvent = new WorkSheetStatusEvent(WorkSheetStatusEvent.MODEL_ADDED);
	}
	
	private function handleReportChange(event:ReportChangedEvent) :void
	{
		if (event.type == ReportChangedEvent.EVENT_ADHOC_REPORT_NAME_CHANGE) {
						
		} else if (event.type == ReportChangedEvent.EVENT_ADHOC_REPORT_ELEMENTS_CHANGE) {
			adhocReportSearchParameters.elements = event.elements;
		} else if (event.type == ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_PATIENT_CHANGE) {
			adhocReportSearchParameters.patient = event.patient;
		} else if (event.type == ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_RESIDENT_CHANGE) {
			adhocReportSearchParameters.resident = event.resident;
		} else if (event.type == ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_START_DATE_CHANGE) {
			adhocReportSearchParameters.startDate = event.startDate;
		} else if (event.type == ReportChangedEvent.EVENT_ADHOC_REPORT_SEARCH_STOP_DATE_CHANGE) {
			adhocReportSearchParameters.endDate = event.stopDate;
		}
	}
	
	private function handleWidgetStateChange(event:WorkSheetWidgetEvent) :void
	{
		if (event.type == WorkSheetWidgetEvent.RESET) {

			if (event.widgetDataType == DetailsEvent.EVENT_DETAILS_MEDS) {
				activeMeds.removeAll();
			} else if (event.widgetDataType == DetailsEvent.EVENT_DETAILS_PLIST) {
				activeProblems.removeAll();
			} else if (event.widgetDataType == LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS) {
				labVOList.removeAll();
			} else if (event.widgetDataType == GetVitalsEvent.EVENT_GET_VITALS || event.widgetDataType == "VS") {
				vitalsModel.vitals.removeAll();
			}
			
		} else if (event.type == WorkSheetWidgetEvent.ERROR)	{
			
		}							
	}
	
	
	public function getWorksheet(worksheetName:String):WorkSheetPanel
	{
		var worksheet:WorkSheetPanel;
		
		if(worksheetName != null) {
			
			worksheet = (worksheetNameToWorksheet[worksheetName] as WorkSheetPanel);						
			
		} 
		
		return worksheet;
	}
	
	public function getWorksheetModel(worksheetName:String):WorkSheetModel
	{
		var model:WorkSheetModel;
		
		if(worksheetName != null) {
			
			model = (worksheetNameToModel[worksheetName] as WorkSheetModel);						
			
		} 
		
		return model;
	}
	
	private function modelExists(worksheetModel:WorkSheetModel):Boolean
	{
		var exists:Boolean = false;
		
		var model:WorkSheetModel;
		
		var modelName:String = worksheetModel.getName();
		
		var curModelName:String;
		
		for (var name:String in worksheetNameToModel)
		{
			curModelName = name;
			
			model = (worksheetNameToModel[name] as WorkSheetModel)
			
			trace("Worksheet name " + name + " : model " + model);
			
			if(curModelName == modelName) {
				exists = true;
			}
		}
		
		return exists;
	}
	
	public function addWorksheetModel(worksheetModel:WorkSheetModel):void
	{	
		if(worksheetModel != null) {
			if(!modelExists(worksheetModel)){
				
				var modelName:String = worksheetModel.getName();
				
				worksheetNameToModel[modelName] = worksheetModel;
				/*
				* Dispatch the added event to place it in the viewstack.
				*/
				worksheetModelAddedEvent.worksheetName = modelName;
				worksheetModelAddedEvent.dispatch();
				
			} else {
				throw new Error("Attempted to add a duplicate worksheet model.");
			}
		} else {
			throw new Error("Attempted to add a null worksheet model.");
		}
	}

	public function addWorksheet(worksheetPanel:WorkSheetPanel):void
	{
		worksheetNameToWorksheet[worksheetPanel.worksheetName] = worksheetPanel;
		worksheetPanel.added();
	}
	
	public function clearValidators():void
	{
		this.validators = [];
	}
	
	/**
	 * Utility method for generating a property chain for Binding. 
	 * @param val - The dot delimeted string to break into a chain.
	 * @return The Array of property chain.
	 * 
	 */
	public function getPropertyChainFromValue(val:String):Array
	{		
		
		var propertyChain:Array = new Array();			
		var delimiter:String = ".";			
			
		if (val != null && val.length > 0) 
		{							
			propertyChain = val.split(delimiter);		 				
		}	
		
		return propertyChain;			
	}
	
} // class
} // package
