package gov.va.med.edp.model
{
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.LogEntryVO;
	import gov.va.med.edp.vo.LookupStringVO;
	
	import mx.collections.ArrayCollection;
	

	[Bindable]
	/**
	 * Log data model.
	 * 
	 *
	 */	
	public class LogEdit
	{
		public var entry: LogEntryVO;
		public var undo: LogEntryVO;
		
		public var processedSensitivePatient:Boolean = false;
		public var patientSelected: Boolean = false;
		public var dirty: Boolean = false;
		public var message: String = "No visit currently selected.";
		public var choiceTS: String = "";
		public var removeMessage: String = "";
		
		public var arrivals: ArrayCollection;
		public var clinics: ArrayCollection;
		public var statuses: ArrayCollection;
		public var acuities: ArrayCollection;
		public var delays: ArrayCollection;
		public var observations: ArrayCollection;
		public var dispositions: ArrayCollection;
		
		// initialize site defined lists to empty array in case site fails to configure
		public var beds: ArrayCollection = new ArrayCollection();
		public var providers: ArrayCollection = new ArrayCollection();
		public var residents: ArrayCollection = new ArrayCollection();
		public var nurses: ArrayCollection = new ArrayCollection();

		
		/**
		 *   Constructor.
		 */
		public function LogEdit() 
		{
		}
		
		public function setEntry(value: LogEntryVO): void
		{
			entry = value;
			message = "";
		}
		
		
		/**
		 *   called if entry is no longer open
		 * 
		 */
		public function resetEntry(): void
		{			
			entry = null;
			var e:TrackingEvent = new TrackingEvent(TrackingEvent.EVENT_RESET_DATETIME);
			e.dispatch();
			this.dirty = false;
			this.message = "No visit currently selected.";
		}
			
		
		/**
		 *  populate the choices 
		 * @param vml of xml type
		 * 
		 */
		public function setChoices(xml:XML):void
		{
			// make sure the choices are set up before setting the logEntry
			choiceTS = xml.@ts;
			
			if (xml.hasOwnProperty("bedList")) {
				beds = SessionFactory.buildLookupBedListFromXML(xml.bedList.bed);
			}
			if (xml.hasOwnProperty("mdList")) {
				providers = SessionFactory.buildLookupStringListFromXML(xml.mdList.md);
			}
			if (xml.hasOwnProperty("resList")) {
				residents = SessionFactory.buildLookupStringListFromXML(xml.resList.res);
			}
			if (xml.hasOwnProperty("nurseList")) {
				nurses = SessionFactory.buildLookupStringListFromXML(xml.nurseList.nurse);
			}
			if (xml.hasOwnProperty("arrivalList")) {
				arrivals = SessionFactory.buildLookupStringListFromXML(xml.arrivalList.arrival);
			}
			if (xml.hasOwnProperty("clinicList")) {
				clinics = SessionFactory.buildLookupStringListFromXML(xml.clinicList.clinic);
			}
			if (xml.hasOwnProperty("acuityList")) {
				acuities = SessionFactory.buildLookupStringListFromXML(xml.acuityList.acuity);
			}
			if (xml.hasOwnProperty("statusList")) {
				statuses = SessionFactory.buildLookupStringListFromXML(xml.statusList.status);
			}
			if (xml.hasOwnProperty("delayList")) {
				delays = SessionFactory.buildLookupStringListFromXML(xml.delayList.delay);
			}
			if (xml.hasOwnProperty("observationList")) {
				delays = SessionFactory.buildLookupStringListFromXML(xml.observationList.observation);
			}
			if (xml.hasOwnProperty("dispositionList")) {
				dispositions = SessionFactory.buildLookupStringListFromXML(xml.dispositionList.disposition);
			}
			
			// add selections to the comboboxes for the persons in the current record, if necessary
			insertValues(providers, xml.persons.provider[0]);
			insertValues(nurses, xml.persons.nurse[0]);
			insertValues(residents, xml.persons.resident[0]);
			insertValues(arrivals, xml.selected.arrival[0]);
			insertValues(clinics, xml.clinics.clinic[0]);
			insertValues(statuses, xml.selected.status[0]);
			insertValues(delays, xml.selected.delay[0]);
			insertValues(observations, xml.selected.observation[0]);
			insertValues(dispositions, xml.selected.disposition[0]);
		}

		private function insertValues(collection: ArrayCollection, xml:XML): void
		{
			if (collection == null) return;
			removeTransients(collection);
			
			if (xml == null) return;
			if (xml.@data == "") return;
			
			var index:int = Vista.locateIndex(collection, xml.@data);
			if (index < 0) {
				var lookup: LookupStringVO = new LookupStringVO;
				lookup.data = xml.@data;
				lookup.label = xml.@label;
				lookup.transient = true;
				ArrayCollection(collection).addItemAt(lookup, collection.length);
				// TODO:  add to the end of the list then sort the collection
			}
		}
		
		private function removeTransients(collection: ArrayCollection): void
		{
			for (var i: int = 0; i < collection.length; i++) {
				var lookupItem: LookupStringVO = collection[i];
				if (lookupItem.transient) {
					collection.removeItemAt(i);
				}
			}
		}

 	}
}
