/* Config.as */

package gov.va.med.edp.model
{
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.DisplayBoardPropertiesVO;
	import gov.va.med.edp.vo.LogEditParamsVO;
	
	import mx.collections.ArrayCollection;
	

	[Bindable]
	/**
	 * Configuration data model.
	 * 
	 *
	 */	
	public class Config
	{
		// configure display board & colors
		public var boards: ArrayCollection = new ArrayCollection();				 // array of LookupVO
		public var boardIndex: int = 0;

		public var columns: ArrayCollection = new ArrayCollection();             // array of ColumnSpecVO		
		public var availableColumns: ArrayCollection = new ArrayCollection();    // array of ColumnSpecVO

		public var colorMaps: ArrayCollection = new ArrayCollection();	         // array of ColorMap
		public var rowColorMap: ColorMapVO;
		public var rowColorMapIndex: int = -1;

		public var displaySizes: ArrayCollection = new ArrayCollection();
		public var displayBoardProperties: DisplayBoardPropertiesVO = new DisplayBoardPropertiesVO();

		// configure rooms/beds
		public var beds: ArrayCollection = new ArrayCollection();		         // array of RoomBedVO
		public var statusList: ArrayCollection = new ArrayCollection();          // array of LookupVO
		public var whenList: ArrayCollection = new ArrayCollection();			 // array of LookupVO
		public var roomCategoryList: ArrayCollection = new ArrayCollection();	 // array of LookupVO
		
		// configure staff
		//public var srcProviders: ArrayCollection;		 // arrays of StaffMemberVO
		//public var srcNurses:  ArrayCollection;
		public var srcStaff: ArrayCollection = new ArrayCollection();
		public var srcStaffReady: Boolean = false;
		
		public var providers: ArrayCollection = new ArrayCollection();
		public var residents: ArrayCollection = new ArrayCollection();
		public var nurses: ArrayCollection = new ArrayCollection();
		public var clerks: ArrayCollection = new ArrayCollection();

		
		// configure selections
		public var acuities: ArrayCollection = new ArrayCollection();			// arrays of CodeSelectionVO
		public var statuses: ArrayCollection = new ArrayCollection();
		public var arrivals: ArrayCollection = new ArrayCollection();
		public var dispositions: ArrayCollection = new ArrayCollection();
		public var delays: ArrayCollection = new ArrayCollection();
		public var acuitiesChanged: Boolean = false;	// dirty flags for each list
		public var statusesChanged: Boolean = false;
		public var arrivalsChanged: Boolean = false;
		public var dispositionsChanged: Boolean = false;
		public var delaysChanged: Boolean = false;
		
		// configure params
		public var params: LogEditParamsVO = new LogEditParamsVO();
		public var defaultRoomList: ArrayCollection = new ArrayCollection();   // array of LookupVO
		
		// loaded flags
		public var bedLoaded: Boolean = false;
		public var boardLoaded: Boolean = false;
		public var colorLoaded: Boolean = false;
		public var paramLoaded: Boolean = false;
		public var selectionConfigLoaded: Boolean = false;
		public var staffConfigLoaded: Boolean = false;

		// dirty flags
		public var bedMods: Boolean = false;
		public var boardMods: Boolean = false;
		public var colorMods: Boolean = false;
		public var paramMods: Boolean = false;
		public var selectionMods: Boolean = false;
		public var staffMods: Boolean = false;
		public var worksheetMods: Boolean = false;
		
		// locking tokens
		public var bedToken: String = "";
		public var boardToken: String = "";
		public var colorToken: String = "";
		public var paramToken: String = "";
		public var selectionToken: String = "";
		public var staffToken: String = "";
		
		/**
		 *   Constructor.
		 */
		public function Config() 
		{
		}
	}
}