package gov.va.med.edp.model
{
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.ColorMatchVO;
	import gov.va.med.edp.vo.ColorSelectionVO;
	import gov.va.med.edp.vo.ColumnSpecVO;
	import gov.va.med.edp.vo.DisplayBoardPropertiesVO;
	
	import mx.collections.ArrayCollection;
	

	[Bindable]
	/**
	 * Board specifications model.
	 * 
	 *
	 */	
	public class BoardSpec
	{
		public var colorMaps: ArrayCollection;		// array of ColorMapVO
		public var columns: ArrayCollection;		// array of ColumnSpecVO
		public var rowColorMap: ColorMapVO;
		public var displayBoardProperties: DisplayBoardPropertiesVO;
		public var configLastUpdated: String;
		public var reloadConfig: Boolean = false;
		public var specReady: Boolean = false;

		/**
		 *   Constructor.
		 */
		public function BoardSpec() 
		{
		}
		/**
		 *   Mapping the color for the cell.
		 * @param att column attribute
		 * @param data for the object
		 */
		public function cellColor(att: String, data: Object): ColorSelectionVO
		{
			var i: int;
			var col: ColumnSpecVO;
			var colorMap: ColorMapVO;
			var colorMatch: ColorMatchVO;
			var defaultColor: ColorSelectionVO = new ColorSelectionVO;
			
			// find the colorMap for this attribute
			for (i = 0; i < columns.length; i++) {
				col = columns[i];
				if (col.attribute == att) {
					colorMap = col.colorMap;
					break;
				} // if
			} // for
			if (colorMap == null) {
				colorMap = rowColorMap;
			}
			if (colorMap == null) return defaultColor;
			
			if (colorMap.type == "rng") {
				// find a color match within the range of the value
				for (i = colorMap.matches.length - 1; i >= 0; i--) {
					colorMatch = colorMap.matches[i];
					if (data.hasOwnProperty(colorMatch.attribute) &&
					   (int(data[colorMatch.attribute]) > int(colorMatch.value))) {
					   return colorMatch.color.ignore ? defaultColor : colorMatch.color;
					} // if				
				}				
			} else {
				// find a match where the attribute is of equal value
				for each (colorMatch in colorMap.matches) {
					if (colorMatch.color.ignore) continue;
					if (data.hasOwnProperty(colorMatch.attribute) &&
					   (data[colorMatch.attribute] == colorMatch.value)) {
					   return colorMatch.color;
					} // if
				} // for				
			}
			
			return defaultColor;
		} // CellColor
	}
}