package gov.va.med.edp.http {
//import gov.va.med.edp.debug.model.RemoteCall;
import mx.logging.Log;
import mx.rpc.IResponder;
import mx.utils.ObjectUtil;

/**
 * Logging the HTTP resonse.
 * 
 *
 */	
public class LoggingHttpRequestResponder implements IResponder {

	private var event:HttpRequestSentEvent;

	/**
	 * Log the request  
	 * @param event event
	 * 
	 */
	public function LoggingHttpRequestResponder(event:HttpRequestSentEvent) {
		this.event = event;
	}
	
	
	/**
	 *  This method is called by a service when the return value
	 *  has been received. 
	 *  While <code>data</code> is typed as Object, it is often
	 *  (but not always) an mx.rpc.events.ResultEvent.
	 */

	public function result(data:Object):void {
		var stopTime:Number = (new Date()).getTime();
		if (Log.isDebug()) {
			//var remoteCall: RemoteCall = RemoteCall.create(event.service, event.params, data, event.timestamp, stopTime - event.timestamp.getTime());
			//Log.getLogger("http").debug("result\n{0}", ObjectUtil.toString(remoteCall));
		}
	}
	
	/**
	 *  This method is called by a service when an error has been received.
	 *  While <code>info</code> is typed as Object it is often
	 *  (but not always) an mx.rpc.events.FaultEvent.
	 */
	public function fault(data:Object):void {
		var stopTime:Number = (new Date()).getTime();
		if (Log.isError()) {
			//var remoteCall: RemoteCall = RemoteCall.create(event.service, event.params, data, event.timestamp, stopTime - event.timestamp.getTime());
			//Log.getLogger("http").error("fault\n{0}", ObjectUtil.toString(remoteCall));
		}
	}

}
}