package gov.va.med.edp.http {
import mx.controls.Label;
import flash.display.DisplayObject;
import mx.core.Application;
import mx.containers.Panel;
import mx.rpc.AsyncToken;
import mx.managers.PopUpManager;
import mx.rpc.http.mxml.HTTPService;
import mx.rpc.IResponder;

/**
 * Maintain an HTTP service.
 * 
 *
 */	
public class BlockingHTTPService extends HTTPService implements IResponder {

    public var block:Boolean = false;

    private var _wait: Panel;

	/**
	 *   Constructor.
	 */
	public function BlockingHTTPService() 
	{
	}
	
    override public function send(parameters:Object = null):AsyncToken {
        var token:AsyncToken = super.send(parameters);
        if (this.block) {
            showWaitWindow();
        }
        return token;
    }
	
	/**
	 *   Activate show wait window
	 * 
	 */
    private function showWaitWindow(): void
    {
        var label: Label = new Label();
        label.text = "Wait...";
        _wait = Panel(PopUpManager.createPopUp(Application.application as DisplayObject, Panel, true));
        _wait.addChild(label);
        PopUpManager.centerPopUp(_wait);
    }
	/**
	 *  This method is called by a service when the return value
	 *  has been received. 
	 *  While <code>data</code> is typed as Object, it is often
	 *  (but not always) an mx.rpc.events.ResultEvent.
	 * remove the popup
	 */
		
    public function result(data:Object):void
    {
        if (this.block) PopUpManager.removePopUp(_wait);
    }

	/**
	 *  This method is called by a service when an error has been received.
	 *  While <code>info</code> is typed as Object it is often
	 *  (but not always) an mx.rpc.events.FaultEvent.
	 * remove the popup
	 */
    public function fault(info:Object):void
    {
        if (this.block) PopUpManager.removePopUp(_wait);
    }

}
}