package gov.va.med.edp.factory
{
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.utils.getDefinitionByName;
	
	import gov.va.med.edp.control.ActiveMedicationsEvent;
	import gov.va.med.edp.control.ActiveProblemsEvent;
	import gov.va.med.edp.control.GetVitalsEvent;
	import gov.va.med.edp.control.LabTrendEvent;
	import gov.va.med.edp.view.worksheet.TimeInTimeOutValidator;
	import gov.va.med.edp.vo.worksheet.ComponentVO;
	import gov.va.med.edp.vo.worksheet.SectionVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetListVO;
	import gov.va.med.edp.vo.worksheet.WorkSheetVO;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.core.UIComponent;
	import mx.utils.ObjectUtil;
	import mx.validators.NumberValidator;
	import mx.validators.StringValidator;
	import mx.validators.Validator;
	
	/**
	 * This factory is designed to build all components of a worksheet.
	 * @author useruseruser12
	 * 
	 */
	public class WorkSheetFactory
	{
		/**
		 * Constructor for the WorkSheetFactory.
		 *  
		 */
		public function WorkSheetFactory()
		{
		}		

		
		/** 
		 * Build the worksheets list from xml data.
		 * 
		 * @param nodeList XML nodelist to build. 
		 * 
		 * @return ArrayCollection of built objects. 
		 */ 		
		public static function buildWorksheetListFromXML(nodeList: XMLList): ArrayCollection
		{		
			var workSheetListVOList:ArrayCollection = new ArrayCollection();
			
			for each (var item: XML in nodeList) {
				
				var workSheetListVO:WorkSheetListVO = new WorkSheetListVO();				
				workSheetListVO = buildWorksheetListItemFromXML(item);
				//Alert.show("WSF.buildWorksheetListFromXML add -> " + workSheetListVO.toString());
				workSheetListVOList.addItem(workSheetListVO);
				
			}
			
			return workSheetListVOList;
		}
		
		/** 
		 * Build a worksheet list item from xml data.
		 * @param xml XML data to build. 
		 * 
		 * @return WorkSheetListVO object. 
		 */ 	
		public static function buildWorksheetListItemFromXML(xml:XML):WorkSheetListVO
		{
			var workSheetListVO:WorkSheetListVO = new WorkSheetListVO();					
			workSheetListVO.id = Number(xml.@id);
			workSheetListVO.data = Number(xml.@id);
			workSheetListVO.type = xml.@type;
			workSheetListVO.disabled = xml.@disabled;
			workSheetListVO.worksheetName = xml.@worksheetName;				
			workSheetListVO.label = xml.@worksheetName;	
			return workSheetListVO;
		}
		
		/**
		 * 
		 * @param xmllist
		 * 
		 */
		public static function buildRoleWorksheet(nodeList:XMLList): ArrayCollection
		{
			var worksheetItems:ArrayCollection = new ArrayCollection([{label:"", data:"x"}]);
			
			for each (var item: XML in nodeList) {
				var roleID:String = item.@id;
				var xx:XMLList = item.children();
				for each(var item2:XML in xx) {
					var name:String = item2.@worksheetName;
					if (item2.@disabled == 'true') {
						name += " *";
					}
					if (item2.@editable == 'false') {
						name += " (default)";
					}
					worksheetItems.addItem( { label: name, data: item2.@id, disabled: item2.@disabled, editable: item2.@editable  } );
				}
			}
			return worksheetItems;
		}
		
		/**
		 * 
		 * @param xml
		 * 
		 */
		public static function buildWorkSheet(xml:XML): WorkSheetVO
		{
			var workSheetVO:WorkSheetVO = new WorkSheetVO();
			
			workSheetVO.name = xml.@name;
			workSheetVO.institution = xml.@institution;
			workSheetVO.area = xml.@area;
			workSheetVO.type = xml.@type;
			workSheetVO.role = xml.@role;
			workSheetVO.disabled = xml.@disabled;
						
			workSheetVO.sectionsVO = buildSections(xml.section);
									
			return workSheetVO;
		}		
		/**
		 * 
		 * @param xml
		 * 
		 */
		public static function buildSection(xml:XML): SectionVO
		{
			var sectionVO:SectionVO = new SectionVO();
//			trace(xml.toXMLString());
			sectionVO.name = xml.@name;
			sectionVO.packageInformation = xml.@packageInformation;
			sectionVO.defaultDisplayName = xml.@defaultDisplayName;
			sectionVO.summary = xml.@summary;
			sectionVO.taskType = xml.@taskType;
			sectionVO.initiallyExpanded = xml.@initialOpen;
			//sectionVO.sequence = xml.@sequence;		
			/*
			*  VistA starts its array indexes at 1 not 0.  We decrement here to sync up with our sequence in arrays.
			*/
			var sequence:int = 0;
			sequence = parseInt(xml.@sequence);
			sectionVO.sequence = sequence - 1;
					
			sectionVO.componentVOArray = 
				createComponentsFromXML(xml.component);					
			
			return sectionVO;
		}
		
		/**
		 * 
		 * @param xml
		 * 
		 */
		private static function buildSections(nodeList: XMLList): ArrayCollection
		{						
			var sections:ArrayCollection = new ArrayCollection();
			
			for each (var item: XML in nodeList) {				
				var sectionVO:SectionVO = buildSection(item);				
				sections.addItem(sectionVO);				
			}
			
			return sections;
		}
		
		
		/**
		 * 
		 * @param componentNode
		 * @return 
		 * 
		 */
		private static function buildComponentRoutineParams(paramsNodeList: XMLList):Array
		{
			var params:Array;
			//var paramsNodeList: XMLList;
			
			if (paramsNodeList != null)
			{
				params = new Array();
				//paramsNodeList = componentNode.@param;
				
				for each (var param: XML in paramsNodeList) {
					
					params[param.@name] = param.@value;
					//trace(params[param.@name]);
					
				}				
			}
			
			return params;
		}
				
		/**
		 * Builds the component given an xml node object.
		 * @param componentNode - The xml node to build from. 
		 */
		public static function buildComponent(componentNode: Object): ComponentVO
		{				
			
			
			
			var clazz:Class;
			var component:UIComponent;
			var properties:XMLList;
			var property:XML;
			var name:String;
			var value:Object;
			var componentVO:ComponentVO;
						
			componentVO = new ComponentVO();
			componentVO.id = componentNode.@id;
			componentVO.name = componentNode.@name;
			componentVO.label = componentNode.@label;
			componentVO.type = componentNode.@type;
			componentVO.visibilityTrigger = componentNode.@visibilityTrigger;
			componentVO.dataProvider = componentNode.@dataProvider;			
			componentVO.value = componentNode.@value;
			componentVO.change = componentNode.@change;
			componentVO.dependentOn = componentNode.@dependentOn;
			componentVO.editable = componentNode.@editable;
			componentVO.available = componentNode.@available;
			componentVO.includeInSummary = componentNode.@includeInSummary;
			componentVO.summaryLabel = componentNode.@summaryLabel;
			componentVO.summaryOrder = componentNode.@summaryOrder;
			//componentVO.sequence = componentNode.@sequence;			
			/*
			 *  VistA starts its array indexes at 1 not 0.  We decrement here to sync up with our sequence in arrays.
			 */
			var sequence:int = 0;
			sequence = parseInt(componentNode.@sequence);
			componentVO.sequence = sequence - 1;
						
	
			/*if(componentNode.validator != null) {
				componentVO.validatorId = componentNode.validator.@id;
				componentVO.validatorType = componentNode.validator.@type;
				componentVO.validatorPropertyBind = componentNode.validator.@property;
				componentVO.validatorMaxLength = componentNode.validator.@maxLength;
				componentVO.validatorMinValue = componentNode.validator.@minValue;
				componentVO.validatorRequired = componentNode.validator.@required;
				componentVO.validatorLowerThanMinError = componentNode.validator.@lowerThanMinError;
			} */
		
			componentVO.loadRoutine = componentNode.loadEvent.@name;
			//componentVO.loadRoutineParamDictionary =
			//	buildComponentRoutineParams(componentNode.loadEvent.param);
			
			//componentVO.loadEvent = createEventInstance(componentNode.loadEvent.@name,componentVO.loadRoutineParamDictionary);
			componentVO.loadEvent = createEventInstance(componentNode.loadEvent.@name);
					
			componentVO.saveRoutine = componentNode.saveRoutine.@name;
			componentVO.saveRoutineParamDictionary = 
				buildComponentRoutineParams(componentNode.saveRoutine.param);
			
			
			component = createComponentInstance(componentVO.type);
			component.id = componentVO.name; // Used for property changes later
						
			componentVO.component = component;
			
			componentVO.validator = createValidator(componentNode,component);
			
			return componentVO;
		}
		
		
		/**
		 * Parses an XML string, returns array of new components.
		 * @param components - The xml list of component nodes.
		 * @return Array all associated components.
		 * 
		 */
		public static function createComponentsFromXML(components:XMLList):Array
		{
			var sortedComponents:Array;
			var componentVO:ComponentVO;
			
			var result:Array = [];
			var child:Object;
			var i:int = 0;
			var n:int = components.length();
			
			for (i; i < n; i++)
			{
				child = components[i];	
				componentVO = buildComponent(child);
				result.push(componentVO);

			}
									
			sortedComponents = sortComponents(result);
			
			return sortedComponents;
		}
		
		private static function sortComponents(components:Array):Array
		{
			var componentVO:ComponentVO;
			var length:int = components.length;
			var sorted:ArrayCollection = new ArrayCollection();
			var index:int = 0;
			var i:int = 0;
			
			var x:int = 0;
			
			//trace("In Size " + length);
			
			// Workaround, arraycollection needs position prior to adding
			for (i; i < length; i++) 
			{
				componentVO = components[i] as ComponentVO;							
				sorted.addItemAt(componentVO,i);
			}
			
			i = 0;
			
			for (i; i < sorted.length; i++) 
			{
				componentVO = components[i] as ComponentVO;							
				//trace("Before Component " + x + " val " + componentVO.label);
			}
			
			i = 0;
			
			for (i; i < sorted.length; i++)
			{
				componentVO = components[i] as ComponentVO;				
				index = componentVO.sequence;
				//index = parseInt(componentVO.sequence);
				//trace("Setting Component " + componentVO.label + " at " + index);
				sorted.setItemAt(componentVO,index);
			}		
						
			//var x:int = 0;
			length  = sorted.length;
			
			//trace("Out Size " + length);
			
			for (x; x < length; x++) 
			{
				componentVO = sorted.getItemAt(x) as ComponentVO;
				
				//trace("After Component " + x + " val " + componentVO.label);
			}
			
			return sorted.source;
			
		}
		
		protected static function traceImportError(type:String):void
		{
			//trace("Please include the class '" + type + "' in the swf.");
			var names:Array = type.split(".");
			var last:String = names[names.length - 1];
			//trace("import " + type + "; " + last + ";");
		}
		
		private static function createComponentInstance(className:String,args:Array = null):UIComponent
		{
			var component:UIComponent;
			
			component = (createInstance(className) as UIComponent);
			
			return component;
		}

		private static function createEventInstance(className:String,params:Array = null):CairngormEvent
		{
			var event:CairngormEvent;
						
			if (className != null && className.length > 0) 
			{			
				event = getEventFromName(className);			
			}
								
			return event;
		}
		
		private static function getEventFromName(name:String):CairngormEvent {
			
			var event:CairngormEvent;
			
			if (name == "gov.va.med.edp.control.ActiveMedicationsEvent") {
				event = new ActiveMedicationsEvent();
			} else if (name == "gov.va.med.edp.control.LabTrendEvent") {
				event = new LabTrendEvent(LabTrendEvent.EVENT_LAB_CHEM_TREND_TEST_IDS);
			} else if (name == "gov.va.med.edp.control.GetVitalsEvent") {
				event = new GetVitalsEvent(GetVitalsEvent.EVENT_GET_VITALS);
			} else if (name == "gov.va.med.edp.control.ActiveProblemsEvent") {
				event = new ActiveProblemsEvent();
			} 
			
			return event;
		}
		
		private static function createInstance(className:String,args:Array = null):Object
		{
			var myClass:Class = getDefinitionByName(className) as Class;
			var instance:Object = new myClass();
			
			if(args != null) 
			{
				instance.initArgs.apply(null, args);	// var obj:Object = createInstance("gov.va.med.edp.view.worksheet.WorkSheetValueComboBox", ["bob", 30]);
			}
			
			return instance;
		}
		
		private static function createValidator(componentNode: Object,sourceComponent:Object):Validator
		{
			var validator:Validator;
		
			var temp:TimeInTimeOutValidator = new TimeInTimeOutValidator(); // Hack to get the class loaded
			
			if(componentNode.validator != null) {
				
				var validatorType:String = componentNode.validator.@type;
				
				if(validatorType != null && validatorType.length > 0) {
					
					validator = createValidatorInstance(validatorType);
					
					validator.required = stringToBoolean(componentNode.validator.@required);
					
					validator.property = componentNode.validator.@property;
					
					validator.source = sourceComponent;
										
					//componentVO.validatorId = componentNode.validator.@id; // Not necessary for objects
					//componentVO.validatorType = componentNode.validator.@type;
					//componentVO.validatorPropertyBind = componentNode.validator.@property;
					//componentVO.validatorMaxLength = componentNode.validator.@maxLength;
					//componentVO.validatorMinValue = componentNode.validator.@minValue;
					//componentVO.validatorRequired = componentNode.validator.@required;
					//componentVO.validatorLowerThanMinError = componentNode.validator.@lowerThanMinError;
					
					
					if(validator is NumberValidator) {
						
						(validator as NumberValidator).minValue = parseInt(componentNode.validator.@minValue);
						(validator as NumberValidator).lowerThanMinError = componentNode.validator.@lowerThanMinError;
						
					} else if (validator is StringValidator) {
						
						(validator as StringValidator).maxLength = componentNode.validator.@maxLength;
						
					} else if (validator is TimeInTimeOutValidator) {
						
						//(validator as TimeInTimeOutValidator).
						
					}					
				}								
			}			
			
			return validator;
		}
		
		
		
		private static function createValidatorInstance(className:String,args:Array = null):Validator
		{
			var validator:Validator;
			
			validator = (createInstance(className) as Validator);
			
			return validator;
		}
		
		private static function stringToBoolean(value:String):Boolean
		{
			var convert:Boolean = Boolean(false);
			
			if(value != null){
				if (value == "true") {
					convert = true;	
				} 
			}		
			return convert;
		}
	}
}