package gov.va.med.edp.factory
{
	import gov.va.med.edp.pt.demog.dao.PatientXml;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.vo.CodeSelectionVO;
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.ColorMatchVO;
	import gov.va.med.edp.vo.ColorSelectionVO;
	import gov.va.med.edp.vo.ColumnSpecVO;
	import gov.va.med.edp.vo.DisplayBoardPropertiesVO;
	import gov.va.med.edp.vo.DisplaySizeVO;
	import gov.va.med.edp.vo.LogEditParamsVO;
	import gov.va.med.edp.vo.LogEntryVO;
	import gov.va.med.edp.vo.LogSelectorVO;
	import gov.va.med.edp.vo.NoteVO;
	import gov.va.med.edp.vo.PCECodedValueVO;
	import gov.va.med.edp.vo.RoomBedVO;
	import gov.va.med.edp.vo.StaffMemberVO;
	import gov.va.med.edp.vo.VisitVO;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
        
	/**
	 * Factory for building tracking session objects.
	 * 
	 *
	 */	
    public class TrackingFactory
    {
		/**
		 * creates an Log edit and LogEditParamsVO value Object  from XML  
		 * @param xml
		 * @return LogEditParamsVO
		 * 
		 */
    	public static function buildLogEditParamsFromXML(xml: XML): LogEditParamsVO
    	{
			
			//Alert.show("buildLogEditParamsFromXML xml.@emptyIEN  = " + xml.@emptyIEN + " xml.@errorIEN = "
			//	+ xml.@errorIEN + " xml.@leftIEN " + xml.@leftIEN);
			
    		var logEditParamsVO: LogEditParamsVO = new LogEditParamsVO();
    		logEditParamsVO.requireDiagnosis = (xml.@reqDiag == "1");
    		logEditParamsVO.requireDisposition = (xml.@reqDisp == "1");
    		logEditParamsVO.requireDelay = (xml.@reqDelay == "1");
    		logEditParamsVO.delayMinutes = int(xml.@minDelay);
    		logEditParamsVO.codedDiagnosis = (xml.@codedDiag == "1");
			logEditParamsVO.freeDiagnosis = !logEditParamsVO.codedDiagnosis;
    		logEditParamsVO.shiftStart = int(xml.@shiftOne);
    		logEditParamsVO.shiftDuration = int(xml.@shiftLen);
    		logEditParamsVO.promptResidents = (xml.@residents == "1");
    		logEditParamsVO.promptClinics = (xml.@clinics == "1");
    		logEditParamsVO.ambulanceArea = int(xml.@ambulance);
    		logEditParamsVO.defaultRoom = int(xml.@dfltroom);
    		logEditParamsVO.emptyValue = int(xml.@emptyIEN);
    		logEditParamsVO.errorIEN = int(xml.@errorIEN);
    		logEditParamsVO.nurseEvalIEN = int(xml.@evalIEN);
    		logEditParamsVO.leftIEN = int(xml.@leftIEN);
			
			//Alert.show("buildLogEditParamsFromXML logEditParamsVO = " + logEditParamsVO.toString());
			
    		return logEditParamsVO;
    	}
    	
		/**
		 * Builds display properties from xml list
		 * @param xmlList XMLList
		 * @return 
		 * 
		 */
    	public static function buildDisplayBoardPropertiesFromXML(xmlList: XMLList): DisplayBoardPropertiesVO
    	{
    		var displayBoardPropertiesVO: DisplayBoardPropertiesVO = new DisplayBoardPropertiesVO();
    		for each (var xml: XML in xmlList) {
				var displaySize:DisplaySizeVO = new DisplaySizeVO();
				displaySize.width = xml.@displayWidth;
				//This loop exists because M dosen't have defaults set.
				//get these defaults set in M
				var dispHt:int = xml.@displayHeight;
				if (dispHt != 0){
					displaySize.height = xml.@displayHeight;
				} else {
					//default it to 768
					displaySize.height = 768;
				}
				
				displaySize.label = xml.@displayLabel;
				displaySize.data = xml.@displayLabel;
				displayBoardPropertiesVO.displaySize = displaySize;
				var fontSize:int = 0;
				fontSize = xml.@fontSize;
				if (fontSize > 0) {
					displayBoardPropertiesVO.fontSize = fontSize;
					displayBoardPropertiesVO.squishFontSize = fontSize;					
				}
				else {
					displayBoardPropertiesVO.fontSize = 10;
					displayBoardPropertiesVO.squishFontSize = 10;
				}
				displayBoardPropertiesVO.scrollDelay = xml.@scrollDelay;
				displayBoardPropertiesVO.squish = (xml.@squish == "true");
    		}
    		return displayBoardPropertiesVO;
    	}
    	    	
		/**
		 * builds screen size and width from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
        public static function buildScreenSizesFromXML(nodeList: XMLList): ArrayCollection
        {
        	var screenSizes:ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var screenSize:DisplaySizeVO = new DisplaySizeVO();
        		screenSize.label = item.@label;
        		screenSize.data = item.@label;
        		screenSize.width = item.@width;
        		screenSize.height = item.@height;
        		screenSizes.addItem(screenSize);
        	}
        	return screenSizes;
        }    	
		/**
		 * creates an Log entry and LogEntryVO value Object  from XML  
		 * @param xml XML
		 * @return LogEntryVO
		 * 
		 */
    	public static function buildLogEntryFromXML(xml:XML):LogEntryVO
    	{
    		var logEntryVO:LogEntryVO = new LogEntryVO();
			if(xml != null) {
				//Alert.show("logEntry = "+xml);
			logEntryVO.id = xml.id;
			logEntryVO.site = xml.site;
			logEntryVO.area = xml.area;
			logEntryVO.dfn = xml.dfn;
			logEntryVO.name = xml.name;
			logEntryVO.ssn = xml.ssn;
			logEntryVO.dob = xml.dob;
			logEntryVO.arrival = int(xml.arrival);
			logEntryVO.inTS = Vista.FMtoDate(xml.inTS);
			logEntryVO.visit = int(xml.visit);
			logEntryVO.closed = (xml.closed == "1");
			logEntryVO.clinic = int(xml.clinic);
			logEntryVO.complaint = xml.complaint;
			logEntryVO.longComplaint = xml.compLong;
			logEntryVO.status = int(xml.status);
			logEntryVO.acuity = int(xml.acuity);
			logEntryVO.bed = int(xml.bed);
			logEntryVO.provider = xml.md;
			logEntryVO.resident = xml.res;
			logEntryVO.nurse = xml.nurse;
			logEntryVO.comment = xml.comment;
			logEntryVO.outTS = Vista.FMtoDate(xml.outTS);
			logEntryVO.delay = int(xml.delay);
			logEntryVO.disposition = int(xml.disposition);
			logEntryVO.diagnoses = new ArrayCollection();
			logEntryVO.patientFlags = PatientXml.buildPtRecordFlagsFromXML(xml.patientRecordFlags.flag);
			logEntryVO.loadTS = xml.loadTS;

			//Alert.show("TrackingFactory buildLogEntryFromXML xml.diagnosis = " + xml.diagnosis);
			
			for each (var item: Object in xml.diagnosis) {
				var pceItem: PCECodedValueVO = new PCECodedValueVO;
				pceItem.type = item.@type;
				pceItem.ien = int(item.@ien);
				pceItem.code = item.@code;
				pceItem.label = item.@label;
				pceItem.primary = (item.@primary == "1");
				pceItem.quantity = int(item.@qty);
				//Alert.show("pceItem = " + pceItem);
				logEntryVO.diagnoses.addItem(pceItem);
			}
			
			var required:String = xml.required;
						
			logEntryVO.required = required;
			logEntryVO.removeReady = (logEntryVO.required.length == 0);
			logEntryVO.restoreReady = logEntryVO.closed;
			
			logEntryVO.restoreReady = logEntryVO.closed;
			
			if (required.indexOf("diag") != -1) logEntryVO.requireDiagnosis = true;
			if (required.indexOf("disp") != -1) logEntryVO.requireDisposition = true;
			if (required.indexOf("delay") != -1) logEntryVO.requireDelay = true;
			
			//INA Educated Guess that this is an added patient.
			//logEntryVO.isNew = ((logEntryVO.complaint.length == 0) && (logEntryVO.visit == 0));
			
			}
			
			return logEntryVO;
    	}
    	
		/* buildLogSelectorListFromXML expects:
        <anyRoot>
            <anyNode id="9999" dfn="99" ptNm="XXXX" ssn="999999999" last4="X9999"
             dob="2380106" bed="XXX" same="1" />
             ...
        </anyRoot> */
		/**
		 * builds log selector from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
        public static function buildLogSelectorListFromXML(nodeList: XMLList): Array
        {
        	var logSelectorVO: LogSelectorVO; 
        	var logSelectorList: Array = [];
        	for each (var item: XML in nodeList) {
	        	logSelectorVO = new LogSelectorVO();
	        	logSelectorVO.id = Number(item.@id);
	        	logSelectorVO.name = item.@name;
	        	logSelectorVO.ssn = item.@ssn;
	        	logSelectorVO.last4 = item.@last4;
	        	logSelectorVO.bed = item.@bed;
	        	logSelectorVO.similar = (item.@same == "1") ? true : false; 
				logSelectorVO.dfn = item.@dfn;
        		logSelectorList.push(logSelectorVO);
        	}
        	return logSelectorList;
        }
		/**
		 * creates an diagnosis list from XML  
		 * @param xml XML
		 * @return diagnosesSelectList
		 * 
		 */
         public static function buildLookupDiagnosesListFromXML(xml:XML): ArrayCollection
        {
        	var codedValueVO: PCECodedValueVO;
        	var diagnosesSelectList: ArrayCollection = new ArrayCollection();
        	
        	//Add support for no matches found..
        	if (xml.children().children().length() == 0){
        		codedValueVO = new PCECodedValueVO;
	        	codedValueVO.code = "";
    	    	codedValueVO.label = "No matches found.";
        		diagnosesSelectList.addItem(codedValueVO);
        	} else {
        		for each (var item:XML in xml.children().children()) {
	        		codedValueVO = new PCECodedValueVO();
	        		var code:String = item.@code;
	        		if (code == null || code == "")	code = item.@cpt;
	        		codedValueVO.type = item.@type;
	        		codedValueVO.ien = item.@ien;
		        	codedValueVO.code = item.@code;
	    	    	codedValueVO.label = item.@text;
	        		diagnosesSelectList.addItem(codedValueVO);
        		}
        	}
        	return diagnosesSelectList;
        }
 
        /* buildColorMapListFromXML expects:
        <colors id="stsAcuity" nm="Status / Acuity" type="val">
         	...
        </colors>
        ... */
		 /**
		  * builds color mapping from the xml list 
		  * @param nodeList XMLList
		  * @return 
		  * 
		  */
		public static function buildColorMapListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var colorMap: ColorMapVO;
        	var list: ArrayCollection = new ArrayCollection();
        	
        	for each (var item: XML in nodeList) {
        		colorMap = new ColorMapVO();
        		colorMap.id = item.@id;
        		colorMap.name = item.@nm;
        		colorMap.type = item.@type;
        		colorMap.matches = buildColorMatchListFromXML(item.map);
        		list.addItem(colorMap);
        	}
        	return list;
        }
 
		/**
		 * verify color selection
		 * @param c string
		 * @return 
		 * 
		 */
 		public static function buildColorSelection(c: String): ColorSelectionVO
 		{
			var sel: ColorSelectionVO = new ColorSelectionVO();
      		var x: Array = c.split(",");
      		sel.ignore = (x[0] != "1");  // 1 means "use color"
    		if (!sel.ignore) {
    			sel.text = uint(x[1]);
    			sel.back = uint(x[2]);
    		}
    		return sel;
 		}
 		
		/* buildColorMatchListFromXML expects:
        <map att="@status" clr="1,0x00ff00,0xff0000" val="10" nm="ED Patient" />
		... */      
		/**
		 * builds color matching from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
        public static function buildColorMatchListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var colorMatch: ColorMatchVO;
        	var list: ArrayCollection = new ArrayCollection();

       		for each (var item: XML in nodeList) {
        		colorMatch = new ColorMatchVO;
        		colorMatch.attribute = item.@att;
        		colorMatch.name = item.@nm;
        		colorMatch.value = item.@val;
        		colorMatch.color = buildColorSelection(item.@clr);
        		
/*  			colorMatch.color = new ColorSelectionVO();
	      		var c: String = item.@clr;
	      		var x: Array = c.split(",");
    	    	colorMatch.color.ignore = (x[0] != "1");  // 1 means "use color"
        		if (!colorMatch.color.ignore) {
        			colorMatch.color.text = uint(x[1]);
        			colorMatch.color.back = uint(x[2]);
        		}
 */        		
        		list.addItem(colorMatch);
        	}
			return list;
        }
        
        /* buildColumnSpecListFromXML expects:
        <col att="bed" header="Bed" color="" width="6" />
        ... */
		/**
		 * builds column list from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
		public static function buildColumnSpecListFromXML(nodeList: XMLList,
			colorMaps: ArrayCollection): ArrayCollection
        {
        	var columnSpec: ColumnSpecVO;
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item:XML in nodeList) {
	        	columnSpec = new ColumnSpecVO();
	        	columnSpec.attribute = item.@att;
	        	columnSpec.header = item.@header;
	        	columnSpec.colorMap = BoardTools.locateColorMap(item.@color, colorMaps);
	        	columnSpec.width = int(item.@width);
	        	columnSpec.label = item.@label;
	        	list.addItem(columnSpec);
        	}
        	return list;
        }
		/**
		 * builds bed list from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
        public static function buildRoomBedListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var bed: RoomBedVO = new RoomBedVO();
        		bed.id = int(item.@id);
        		bed.area = int(item.@area);
        		bed.name = item.@name;
        		bed.inactive = (item.@inactive == "1");
				bed.primary = item.@primary;
				bed.sequence = int(item.@seq);
				bed.displayName = item.@display;
				bed.displayWhen = item.@when;
				bed.defaultStatus = item.@status;
				bed.category = item.@category;
				bed.sharedName = item.@shared;
				bed.boardName = item.@board;
				bed.color = buildColorSelection(item.@color);
				list.addItem(bed);		
        	}
        	return list;
        }
		/**
		 * builds code for selection from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
        public static function buildCodeSelectionListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var sel: CodeSelectionVO = new CodeSelectionVO();
        		sel.id = int(item.@id);
        		sel.name = item.@nm;
        		sel.displayName = item.@show;
        		sel.abbreviation = item.@abbr;
        		sel.flag = item.@flag;
        		sel.inactive = (item.@inact == "1") ? true : false;
        		sel.national = item.@natl;
        		list.addItem(sel);
        	}
        	return list;
        }
        
        // <staff duz="123" nm="WELBY,MARCUS" itl="MW" role="P" clr="1,0x00ff00,0xff0000" />
		/**
		 * builds staff list from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
        public static function buildStaffListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var person: StaffMemberVO = new StaffMemberVO();
        		person.duz = item.@duz;
        		person.name = item.@nm;
        		person.initials = item.@itl;
        		var title:String = item.@title;
        		person.role = item.@role;
        		if (title.length > 0){
        		person.displayName = item.@nm + " (" + title + ")";
        		} else {
        		person.displayName = item.@nm;
        		}
        		person.color = buildColorSelection(item.@clr);
        		list.addItem(person);
        	}
        	return list;
        }
        
		/* Added last4 tto the closed visit search  - Nader Aghili 10/14/11 */
		/**
		 * builds visit list  from the xml list 
		 * @param nodeList XMLList
		 * @return 
		 * 
		 */
		
		public static function buildVisitListFromXML(nodeList: XMLList): ArrayCollection
		{
			var list: ArrayCollection = new ArrayCollection();
			if (nodeList.length() == 0) {
				var emptyVisit: VisitVO = new VisitVO();
				emptyVisit.id = -1;
				emptyVisit.name = "No matches found.";
				list.addItem(emptyVisit);
				return list;
			} else {
				for each (var item: XML in nodeList) {
					var visit: VisitVO = new VisitVO();
					visit.id = item.@id;
					visit.name = item.@name;
					visit.inTS = Vista.FMtoDate(item.@inTS);
					visit.last4 =  item.@last4;
					list.addItem(visit);
				}
				return list;
			}       	
		}            
        
        private static function buildNotesFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var note: NoteVO = new NoteVO();
        		note.action = item.@action;
        		note.author = item.@author;
        		note.id = item.@id;
        		note.noteDate = Vista.FMtoDate(item.@noteTS);
        		note.text = item.text;
        		list.addItem(note);
        	}
        	return list;
        }        
                       
    }
}
